/*
 * Decompiled with CFR 0.152.
 */
package org.yatech.jedis.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.yatech.jedis.collections.JedisCallable;
import org.yatech.jedis.collections.JedisCollectionBase;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class JedisList
extends JedisCollectionBase
implements Collection<String> {
    JedisList(JedisPool jedisPool, int db, String key) {
        super(jedisPool, db, key);
    }

    JedisList(Jedis jedis, String key) {
        super(jedis, key);
    }

    @Override
    public int size() {
        return Integer.valueOf("" + this.length());
    }

    public long length() {
        return this.doWithJedis(new JedisCallable<Long>(){

            @Override
            public Long call(Jedis jedis) {
                return jedis.llen(JedisList.this.getKey());
            }
        });
    }

    @Override
    public boolean isEmpty() {
        return this.length() == 0L;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o.toString()) >= 0L;
    }

    @Override
    public Iterator<String> iterator() {
        return this.toList().iterator();
    }

    public List<String> toList() {
        return this.doWithJedis(new JedisCallable<List<String>>(){

            @Override
            public List<String> call(Jedis jedis) {
                return jedis.lrange(JedisList.this.getKey(), 0L, jedis.llen(JedisList.this.getKey()) - 1L);
            }
        });
    }

    @Override
    public Object[] toArray() {
        return this.toList().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.toList().toArray(a);
    }

    @Override
    public boolean add(final String s) {
        return this.doWithJedis(new JedisCallable<Boolean>(){

            @Override
            public Boolean call(Jedis jedis) {
                jedis.rpush(JedisList.this.getKey(), new String[]{s});
                return true;
            }
        });
    }

    @Override
    public boolean remove(final Object o) {
        return this.doWithJedis(new JedisCallable<Boolean>(){

            @Override
            public Boolean call(Jedis jedis) {
                long removed = jedis.lrem(JedisList.this.getKey(), 1L, o.toString());
                return removed > 0L;
            }
        });
    }

    @Override
    public boolean containsAll(final Collection<?> c) {
        return this.doWithJedis(new JedisCallable<Boolean>(){

            @Override
            public Boolean call(Jedis jedis) {
                for (Object o : c) {
                    if (JedisList.this.doIndexOf(jedis, o.toString()) >= 0L) continue;
                    return false;
                }
                return true;
            }
        });
    }

    @Override
    public boolean addAll(final Collection<? extends String> c) {
        return this.doWithJedis(new JedisCallable<Boolean>(){

            @Override
            public Boolean call(Jedis jedis) {
                long added = jedis.rpush(JedisList.this.getKey(), c.toArray(new String[c.size()]));
                return added > 0L;
            }
        });
    }

    @Override
    public boolean removeAll(final Collection<?> c) {
        return this.doWithJedis(new JedisCallable<Boolean>(){

            @Override
            public Boolean call(Jedis jedis) {
                long removed = 0L;
                for (Object o : c) {
                    removed += jedis.lrem(JedisList.this.getKey(), jedis.llen(JedisList.this.getKey()).longValue(), o.toString()).longValue();
                }
                return removed > 0L;
            }
        });
    }

    @Override
    public boolean retainAll(final Collection<?> c) {
        return this.doWithJedis(new JedisCallable<Boolean>(){

            @Override
            public Boolean call(Jedis jedis) {
                long removed = 0L;
                long fromIndex = 0L;
                while ((fromIndex = JedisList.this.indexOfElementNotInCollection(jedis, fromIndex, c)) >= 0L) {
                    String element = jedis.lindex(JedisList.this.getKey(), fromIndex);
                    removed += jedis.lrem(JedisList.this.getKey(), jedis.llen(JedisList.this.getKey()).longValue(), element).longValue();
                }
                return removed > 0L;
            }
        });
    }

    private long indexOfElementNotInCollection(Jedis jedis, long fromIndex, Collection<?> c) {
        long len = jedis.llen(this.getKey());
        for (long i = fromIndex; i < len; ++i) {
            String element = jedis.lindex(this.getKey(), i);
            if (c.contains(element)) continue;
            return i;
        }
        return -1L;
    }

    @Override
    public void clear() {
        this.doWithJedis(new JedisCallable<Void>(){

            @Override
            public Void call(Jedis jedis) {
                jedis.del(JedisList.this.getKey());
                return null;
            }
        });
    }

    public long indexOf(final String element) {
        return this.doWithJedis(new JedisCallable<Long>(){

            @Override
            public Long call(Jedis jedis) {
                return JedisList.this.doIndexOf(jedis, element);
            }
        });
    }

    private Long doIndexOf(Jedis jedis, String element) {
        long length = jedis.llen(this.getKey());
        for (long i = 0L; i < length; ++i) {
            if (!element.equals(jedis.lindex(this.getKey(), i))) continue;
            return i;
        }
        return -1L;
    }

    public String get(final long index) {
        return this.doWithJedis(new JedisCallable<String>(){

            @Override
            public String call(Jedis jedis) {
                return jedis.lindex(JedisList.this.getKey(), index);
            }
        });
    }

    public List<String> subList(final long fromIndex, final long toIndex) {
        return this.doWithJedis(new JedisCallable<List<String>>(){

            @Override
            public List<String> call(Jedis jedis) {
                return jedis.lrange(JedisList.this.getKey(), fromIndex, toIndex);
            }
        });
    }
}

