/*
 * Decompiled with CFR 0.152.
 */
package org.yamj.api.common.http;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.yamj.api.common.http.CommonHttpClient;
import org.yamj.api.common.http.DigestedResponse;
import org.yamj.api.common.http.DigestedResponseReader;
import org.yamj.api.common.http.IUserAgentSelector;

public class HttpClientWrapper
implements CommonHttpClient,
Closeable {
    private final HttpClient httpClient;
    private IUserAgentSelector userAgentSelector;

    public HttpClientWrapper(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public HttpClientWrapper(HttpClient httpClient, IUserAgentSelector userAgentSelector) {
        this.httpClient = httpClient;
        this.userAgentSelector = userAgentSelector;
    }

    @Override
    public void setUserAgentSelector(IUserAgentSelector userAgentSelector) {
        this.userAgentSelector = userAgentSelector;
    }

    protected void prepareRequest(HttpUriRequest request) throws ClientProtocolException {
        Header[] headers;
        if (this.userAgentSelector != null && ((headers = request.getHeaders("User-Agent")) == null || headers.length == 0)) {
            request.setHeader("User-Agent", this.userAgentSelector.getUserAgent());
        }
    }

    protected void prepareRequest(HttpHost target, HttpRequest request) throws ClientProtocolException {
        Header[] headers;
        if (this.userAgentSelector != null && ((headers = request.getHeaders("User-Agent")) == null || headers.length == 0)) {
            request.setHeader("User-Agent", this.userAgentSelector.getUserAgent());
        }
    }

    protected static HttpHost determineTarget(HttpUriRequest request) throws ClientProtocolException {
        HttpHost target = null;
        URI requestURI = request.getURI();
        if (requestURI.isAbsolute() && (target = URIUtils.extractHost((URI)requestURI)) == null) {
            throw new ClientProtocolException("URI does not specify a valid host name: " + requestURI);
        }
        return target;
    }

    @Override
    public DigestedResponse requestContent(URL url) throws IOException {
        return this.requestContent(url, null);
    }

    @Override
    public DigestedResponse requestContent(URL url, Charset charset) throws IOException {
        return this.requestContent(HttpClientWrapper.toURI(url), charset);
    }

    @Override
    public DigestedResponse requestContent(String uri) throws IOException {
        return this.requestContent(uri, null);
    }

    @Override
    public DigestedResponse requestContent(String uri, Charset charset) throws IOException {
        HttpGet httpGet = new HttpGet(uri);
        return this.requestContent(httpGet, charset);
    }

    @Override
    public DigestedResponse requestContent(URI uri) throws IOException {
        return this.requestContent(uri, null);
    }

    @Override
    public DigestedResponse requestContent(URI uri, Charset charset) throws IOException {
        HttpGet httpGet = new HttpGet(uri);
        return this.requestContent(httpGet, charset);
    }

    @Override
    public DigestedResponse requestContent(HttpGet httpGet) throws IOException {
        return this.requestContent(httpGet, null);
    }

    @Override
    public DigestedResponse requestContent(HttpGet httpGet, Charset charset) throws IOException {
        return DigestedResponseReader.requestContent(this, httpGet, charset);
    }

    @Override
    public DigestedResponse postContent(URL url, HttpEntity entity) throws IOException {
        return this.postContent(url, entity, null);
    }

    @Override
    public DigestedResponse postContent(URL url, HttpEntity entity, Charset charset) throws IOException {
        return this.postContent(HttpClientWrapper.toURI(url), entity, charset);
    }

    @Override
    public DigestedResponse postContent(String uri, HttpEntity entity) throws IOException {
        return this.postContent(uri, entity, null);
    }

    @Override
    public DigestedResponse postContent(String uri, HttpEntity entity, Charset charset) throws IOException {
        HttpPost httpPost = new HttpPost(uri);
        httpPost.setEntity(entity);
        return this.postContent(httpPost, charset);
    }

    @Override
    public DigestedResponse postContent(URI uri, HttpEntity entity) throws IOException {
        return this.postContent(uri, entity, null);
    }

    @Override
    public DigestedResponse postContent(URI uri, HttpEntity entity, Charset charset) throws IOException {
        HttpPost httpPost = new HttpPost(uri);
        httpPost.setEntity(entity);
        return this.postContent(httpPost, charset);
    }

    @Override
    public DigestedResponse postContent(HttpPost httpPost) throws IOException {
        return this.postContent(httpPost, null);
    }

    @Override
    public DigestedResponse postContent(HttpPost httpPost, Charset charset) throws IOException {
        return DigestedResponseReader.postContent(this, httpPost, charset);
    }

    @Override
    public DigestedResponse deleteContent(URL url) throws IOException {
        return this.deleteContent(url, null);
    }

    @Override
    public DigestedResponse deleteContent(URL url, Charset charset) throws IOException {
        return this.deleteContent(HttpClientWrapper.toURI(url), charset);
    }

    @Override
    public DigestedResponse deleteContent(String uri) throws IOException {
        return this.deleteContent(uri, null);
    }

    @Override
    public DigestedResponse deleteContent(String uri, Charset charset) throws IOException {
        HttpDelete httpDelete = new HttpDelete(uri);
        return this.deleteContent(httpDelete, charset);
    }

    @Override
    public DigestedResponse deleteContent(URI uri) throws IOException {
        return this.deleteContent(uri, null);
    }

    @Override
    public DigestedResponse deleteContent(URI uri, Charset charset) throws IOException {
        HttpDelete httpDelete = new HttpDelete(uri);
        return this.deleteContent(httpDelete, charset);
    }

    @Override
    public DigestedResponse deleteContent(HttpDelete httpDelete) throws IOException {
        return this.deleteContent(httpDelete, null);
    }

    @Override
    public DigestedResponse deleteContent(HttpDelete httpDelete, Charset charset) throws IOException {
        return DigestedResponseReader.deleteContent(this, httpDelete, charset);
    }

    @Override
    public HttpEntity requestResource(URL url) throws IOException {
        return this.requestResource(HttpClientWrapper.toURI(url));
    }

    @Override
    public HttpEntity requestResource(String uri) throws IOException {
        HttpGet httpGet = new HttpGet(uri);
        return this.requestResource(httpGet);
    }

    @Override
    public HttpEntity requestResource(URI uri) throws IOException {
        HttpGet httpGet = new HttpGet(uri);
        return this.requestResource(httpGet);
    }

    @Override
    public HttpEntity requestResource(HttpGet httpGet) throws IOException {
        return this.execute((HttpUriRequest)httpGet).getEntity();
    }

    @Override
    public HttpEntity postResource(URL url, HttpEntity entity) throws IOException {
        return this.postResource(HttpClientWrapper.toURI(url), entity);
    }

    @Override
    public HttpEntity postResource(String uri, HttpEntity entity) throws IOException {
        HttpPost httpPost = new HttpPost(uri);
        httpPost.setEntity(entity);
        return this.postResource(httpPost);
    }

    @Override
    public HttpEntity postResource(URI uri, HttpEntity entity) throws IOException {
        HttpPost httpPost = new HttpPost(uri);
        httpPost.setEntity(entity);
        return this.postResource(httpPost);
    }

    @Override
    public HttpEntity postResource(HttpPost httpPost) throws IOException {
        return this.execute((HttpUriRequest)httpPost).getEntity();
    }

    @Override
    public HttpEntity deleteResource(URL url) throws IOException {
        return this.deleteResource(HttpClientWrapper.toURI(url));
    }

    @Override
    public HttpEntity deleteResource(String uri) throws IOException {
        HttpDelete httpDelete = new HttpDelete(uri);
        return this.deleteResource(httpDelete);
    }

    @Override
    public HttpEntity deleteResource(URI uri) throws IOException {
        HttpDelete httpDelete = new HttpDelete(uri);
        return this.deleteResource(httpDelete);
    }

    @Override
    public HttpEntity deleteResource(HttpDelete httpDelete) throws IOException {
        return this.execute((HttpUriRequest)httpDelete).getEntity();
    }

    public HttpResponse execute(HttpUriRequest request) throws IOException {
        this.prepareRequest(request);
        return this.httpClient.execute(request);
    }

    public HttpResponse execute(HttpUriRequest request, HttpContext context) throws IOException {
        this.prepareRequest(request);
        return this.httpClient.execute(request, context);
    }

    public HttpResponse execute(HttpHost target, HttpRequest request) throws IOException {
        this.prepareRequest(target, request);
        return this.httpClient.execute(target, request);
    }

    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        this.prepareRequest(request);
        return (T)this.httpClient.execute(request, responseHandler);
    }

    public HttpResponse execute(HttpHost target, HttpRequest request, HttpContext context) throws IOException {
        this.prepareRequest(target, request);
        return this.httpClient.execute(target, request, context);
    }

    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
        this.prepareRequest(request);
        return (T)this.httpClient.execute(request, responseHandler, context);
    }

    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        this.prepareRequest(target, request);
        return (T)this.httpClient.execute(target, request, responseHandler);
    }

    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
        this.prepareRequest(target, request);
        return (T)this.httpClient.execute(target, request, responseHandler, context);
    }

    @Deprecated
    public ClientConnectionManager getConnectionManager() {
        return this.httpClient.getConnectionManager();
    }

    @Deprecated
    public HttpParams getParams() {
        return this.httpClient.getParams();
    }

    @Override
    public void close() throws IOException {
        if (this.httpClient instanceof Closeable) {
            ((Closeable)this.httpClient).close();
        }
    }

    protected static URI toURI(URL url) {
        try {
            return url.toURI();
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("Invalid URL: " + url, ex);
        }
    }
}

