/*
 * Decompiled with CFR 0.152.
 */
package org.yamj.api.common.http;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yamj.api.common.http.DigestedResponse;

public class DigestedResponseReader {
    private static final Logger LOG = LoggerFactory.getLogger(DigestedResponseReader.class);
    private static final int SW_BUFFER_10K = 10240;
    private static final int HTTP_STATUS_503 = 503;

    private DigestedResponseReader() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static DigestedResponse requestContent(HttpClient httpClient, HttpGet httpGet, Charset charset) throws IOException {
        return DigestedResponseReader.processRequest(httpClient, (HttpRequestBase)httpGet, charset);
    }

    public static DigestedResponse deleteContent(HttpClient httpClient, HttpDelete httpDelete, Charset charset) throws IOException {
        return DigestedResponseReader.processRequest(httpClient, (HttpRequestBase)httpDelete, charset);
    }

    public static DigestedResponse postContent(HttpClient httpClient, HttpPost httpPost, Charset charset) throws IOException {
        return DigestedResponseReader.processRequest(httpClient, (HttpRequestBase)httpPost, charset);
    }

    private static DigestedResponse processRequest(HttpClient httpClient, HttpRequestBase httpRequest, Charset charset) throws IOException {
        try {
            HttpResponse response = httpClient.execute((HttpUriRequest)httpRequest);
            DigestedResponse digestedResponse = new DigestedResponse();
            digestedResponse.setStatusCode(response.getStatusLine().getStatusCode());
            if (response.getEntity() != null) {
                digestedResponse.setContent(DigestedResponseReader.getContent(response, charset));
            }
            return digestedResponse;
        }
        catch (SocketTimeoutException | ConnectTimeoutException ex) {
            LOG.trace("Timeout exception", ex);
            httpRequest.releaseConnection();
            return new DigestedResponse(503, "");
        }
        catch (IOException ex) {
            httpRequest.releaseConnection();
            throw ex;
        }
    }

    /*
     * Exception decompiling
     */
    private static String getContent(HttpResponse response, Charset charset) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

