/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.wikimodel.util;

import java.util.ArrayList;
import java.util.List;

public final class TreeBuilder<X extends IPos<X>> {
    public List<X> fList = new ArrayList<X>();
    private ITreeListener<X> fListener;

    private static <X extends IPos<X>> void addTail(ITreeListener<X> listener, List<X> firstArray, List<X> secondArray, int secondPos, boolean openTree) {
        X n = TreeBuilder.getNode(secondArray, secondPos);
        if (n == null) {
            return;
        }
        if (openTree) {
            listener.onBeginTree(n);
        }
        listener.onBeginRow(n);
        firstArray.add(n);
        TreeBuilder.addTail(listener, firstArray, secondArray, secondPos + 1, true);
    }

    private static <X extends IPos<X>> void doAlign(ITreeListener<X> listener, List<X> firstArray, List<X> secondArray, boolean expand) {
        int f;
        boolean newTree = true;
        int firstLen = firstArray.size();
        int secondLen = secondArray.size();
        int s = 0;
        for (f = 0; f < firstLen && s < secondLen; ++f) {
            int secondPos;
            IPos first = (IPos)firstArray.get(f);
            IPos second = (IPos)secondArray.get(s);
            int firstPos = first.getPos();
            if (firstPos < (secondPos = second.getPos())) continue;
            if (!first.equalsData(second)) break;
            if (s == secondLen - 1) {
                newTree = false;
                break;
            }
            ++s;
        }
        TreeBuilder.removeTail(listener, firstArray, f, newTree, expand);
        if (expand) {
            TreeBuilder.addTail(listener, firstArray, secondArray, s, newTree);
        }
    }

    private static <X extends IPos<X>> X getNode(List<X> list, int pos) {
        return (X)(pos < 0 || pos >= list.size() ? null : (IPos)list.get(pos));
    }

    private static <X extends IPos<X>> void removeTail(ITreeListener<X> listener, List<X> array, int pos, boolean closeTree, boolean remove) {
        X node = TreeBuilder.getNode(array, pos);
        if (node == null) {
            return;
        }
        TreeBuilder.removeTail(listener, array, pos + 1, true, true);
        listener.onEndRow(node);
        if (closeTree) {
            listener.onEndTree(node);
        }
        if (remove) {
            array.remove(pos);
        }
    }

    public TreeBuilder(ITreeListener<X> listener) {
        this.fListener = listener;
    }

    public void align(List<X> row) {
        TreeBuilder.doAlign(this.fListener, this.fList, row, true);
    }

    public void align(X pos) {
        ArrayList<X> list = new ArrayList<X>();
        if (pos != null) {
            list.add(pos);
        }
        this.align((X)list);
    }

    public X get(int pos) {
        return (X)(pos >= 0 && pos < this.fList.size() ? (IPos)this.fList.get(pos) : null);
    }

    public X getPeek() {
        return this.get(this.fList.size() - 1);
    }

    public void trim(List<X> row) {
        TreeBuilder.doAlign(this.fListener, this.fList, row, false);
    }

    public void trim(X pos) {
        ArrayList<X> list = new ArrayList<X>();
        if (pos != null) {
            list.add(pos);
        }
        this.trim((X)list);
    }

    public static interface IPos<X extends IPos<X>> {
        public boolean equalsData(X var1);

        public int getPos();
    }

    public static interface ITreeListener<X extends IPos<X>> {
        public void onBeginRow(X var1);

        public void onBeginTree(X var1);

        public void onEndRow(X var1);

        public void onEndTree(X var1);
    }
}

