/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.transformation.macro;

import java.util.List;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.MacroMarkerBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.util.ErrorBlockGenerator;

public class MacroErrorManager {
    private ErrorBlockGenerator errorBlockGenerator;

    public MacroErrorManager(ErrorBlockGenerator errorBlockGenerator) {
        this.errorBlockGenerator = errorBlockGenerator;
    }

    public boolean containsError(XDOM xdom) {
        return this.errorBlockGenerator.containsError((Block)xdom);
    }

    private Block wrapInMacroMarker(MacroBlock macroBlockToWrap, List<Block> newBlocks) {
        return new MacroMarkerBlock(macroBlockToWrap.getId(), macroBlockToWrap.getParameters(), macroBlockToWrap.getContent(), newBlocks, macroBlockToWrap.isInline());
    }

    public void generateError(MacroBlock macroToReplace, String messageId, String defaultMessage, String defaultDescription, Object ... arguments) {
        List errorBlocks = this.errorBlockGenerator.generateErrorBlocks(macroToReplace.isInline(), messageId, defaultMessage, defaultDescription, arguments);
        macroToReplace.getParent().replaceChild(this.wrapInMacroMarker(macroToReplace, errorBlocks), (Block)macroToReplace);
    }
}

