/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.xhtml.wikimodel;

import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.internal.parser.XDOMGeneratorListener;
import org.xwiki.rendering.internal.parser.wikimodel.WikiModelStreamParser;
import org.xwiki.rendering.internal.parser.wikimodel.XWikiGeneratorListener;
import org.xwiki.rendering.internal.parser.xhtml.wikimodel.XWikiWikiModelHandler;
import org.xwiki.rendering.internal.parser.xhtml.wikimodel.XWikiWikiReference;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.rendering.wikimodel.IWemListener;
import org.xwiki.rendering.wikimodel.WikiParameter;
import org.xwiki.rendering.wikimodel.WikiParameters;
import org.xwiki.rendering.wikimodel.WikiReference;
import org.xwiki.rendering.wikimodel.impl.WikiScannerContext;
import org.xwiki.rendering.wikimodel.xhtml.handler.ReferenceTagHandler;
import org.xwiki.rendering.wikimodel.xhtml.impl.TagContext;
import org.xwiki.rendering.wikimodel.xhtml.impl.TagStack;

public class XWikiReferenceTagHandler
extends ReferenceTagHandler
implements XWikiWikiModelHandler {
    private static final Pattern URL_SCHEME_PATTERN = Pattern.compile("[a-zA-Z0-9+.-]*://");
    private static final String MAILTO_PREFIX = "mailto:";
    private WikiModelStreamParser parser;

    public XWikiReferenceTagHandler(WikiModelStreamParser parser) {
        this.parser = parser;
    }

    public void initialize(TagStack stack) {
        stack.setStackParameter("isInLink", (Object)Boolean.FALSE);
        stack.setStackParameter("isFreeStandingLink", (Object)Boolean.FALSE);
        stack.setStackParameter("linkParameters", (Object)WikiParameters.EMPTY);
    }

    protected void begin(TagContext context) {
        boolean isInLink = (Boolean)context.getTagStack().getStackParameter("isInLink");
        if (isInLink) {
            XWikiGeneratorListener listener = (XWikiGeneratorListener)context.getTagStack().getStackParameter("linkListener");
            context.getTagStack().pushScannerContext(new WikiScannerContext((IWemListener)listener));
            context.getScannerContext().beginDocument();
            if (this.isFreeStandingReference(context)) {
                context.getTagStack().setStackParameter("isFreeStandingLink", (Object)Boolean.TRUE);
            } else {
                context.getTagStack().setStackParameter("linkParameters", (Object)this.removeMeaningfulParameters(context.getParams()));
            }
            this.setAccumulateContent(false);
        } else if (!this.isFreeStandingReference(context)) {
            WikiParameter ref = context.getParams().getParameter("href");
            if (ref != null) {
                XWikiGeneratorListener xwikiListener = this.parser.createXWikiGeneratorListener((Listener)new XDOMGeneratorListener(), null);
                context.getTagStack().pushScannerContext(new WikiScannerContext((IWemListener)xwikiListener));
                context.getScannerContext().beginDocument();
            } else {
                WikiParameter idName = context.getParams().getParameter("id");
                if (idName == null) {
                    idName = context.getParams().getParameter("name");
                }
                if (idName != null) {
                    WikiParameter parameter = new WikiParameter("name", idName.getValue());
                    WikiParameters parameters = new WikiParameters(Collections.singletonList(parameter));
                    context.getScannerContext().onExtensionBlock("xwiki_id", parameters);
                }
            }
        } else {
            super.begin(context);
        }
    }

    protected void end(TagContext context) {
        boolean isInLink = (Boolean)context.getTagStack().getStackParameter("isInLink");
        if (isInLink) {
            context.getScannerContext().endDocument();
            context.getTagStack().popScannerContext();
        } else if (!this.isFreeStandingReference(context)) {
            WikiParameters parameters = context.getParams();
            WikiParameter ref = parameters.getParameter("href");
            if (ref != null) {
                context.getScannerContext().endDocument();
                WikiScannerContext scannerContext = context.getTagStack().popScannerContext();
                XWikiGeneratorListener xwikiListener = (XWikiGeneratorListener)scannerContext.getfListener();
                XDOMGeneratorListener linkLabelRenderer = (XDOMGeneratorListener)xwikiListener.getListener();
                XDOM label = linkLabelRenderer.getXDOM();
                ResourceReference resourceReference = this.computeResourceReference(ref.getValue());
                XWikiWikiReference reference = new XWikiWikiReference(resourceReference, label, this.removeMeaningfulParameters(parameters), false);
                context.getScannerContext().onReference((WikiReference)reference);
            }
        } else {
            super.end(context);
        }
    }

    private ResourceReference computeResourceReference(String rawReference) {
        Matcher matcher = URL_SCHEME_PATTERN.matcher(rawReference);
        ResourceReference reference = matcher.lookingAt() ? new ResourceReference(rawReference, ResourceType.URL) : (rawReference.startsWith(MAILTO_PREFIX) ? new ResourceReference(rawReference.substring(MAILTO_PREFIX.length()), ResourceType.MAILTO) : new ResourceReference(rawReference, ResourceType.PATH));
        return reference;
    }
}

