/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser.xhtml.wikimodel;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.rendering.parser.ResourceReferenceParser;
import org.xwiki.rendering.wikimodel.WikiParameter;
import org.xwiki.rendering.wikimodel.WikiParameters;

@Component
@Named(value="xhtmlmarker")
@Singleton
public class XHTMLMarkerResourceReferenceParser
implements ResourceReferenceParser {
    private static final String COMMENT_SEPARATOR = "|-|";
    @Inject
    private Logger logger;

    public ResourceReference parse(String rawReference) {
        String reference;
        ResourceType type;
        boolean isTyped;
        String[] tokens = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)rawReference, (String)COMMENT_SEPARATOR);
        if (tokens.length < 3) {
            this.logger.warn("Comment resource [{}] is missing resource type, falling back to document.", (Object)rawReference);
            isTyped = false;
            type = ResourceType.DOCUMENT;
            reference = rawReference;
        } else {
            isTyped = "true".equalsIgnoreCase(tokens[0]);
            type = new ResourceType(tokens[1]);
            reference = tokens[2];
        }
        ResourceReference resourceReference = new ResourceReference(reference, type);
        resourceReference.setTyped(isTyped);
        if (tokens.length == 4) {
            for (WikiParameter parameter : WikiParameters.newWikiParameters((String)tokens[3])) {
                resourceReference.setParameter(parameter.getKey(), parameter.getValue());
            }
        }
        return resourceReference;
    }
}

