/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.xdomxml.internal.current.renderer;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xwiki.rendering.listener.descriptor.ListenerDescriptor;
import org.xwiki.rendering.listener.descriptor.ListenerElement;
import org.xwiki.rendering.xdomxml.internal.current.parameter.ParameterManager;

public class XDOMXMLChainingStreamRenderer
implements InvocationHandler {
    private ContentHandler contentHandler;
    private ParameterManager parameterManager;
    private ListenerDescriptor descriptor;

    public XDOMXMLChainingStreamRenderer(ParameterManager parameterManager, ListenerDescriptor descriptor) {
        this.parameterManager = parameterManager;
        this.descriptor = descriptor;
    }

    private String getBlockName(String eventName, String prefix) {
        String blockName = eventName.substring(prefix.length());
        blockName = Character.toLowerCase(blockName.charAt(0)) + blockName.substring(1);
        return blockName;
    }

    private void beginEvent(String eventName, Object[] parameters) {
        String blockName = this.getBlockName(eventName, "begin");
        this.startElement("block", new String[][]{{"name", blockName}});
        this.printParameters(parameters, (ListenerElement)this.descriptor.getElements().get(blockName.toLowerCase()));
    }

    private void endEvent() {
        this.endElement("block");
    }

    private void onEvent(String eventName, Object[] parameters) {
        String blockName = this.getBlockName(eventName, "on");
        this.startElement("block", new String[][]{{"name", blockName}});
        this.printParameters(parameters, (ListenerElement)this.descriptor.getElements().get(blockName));
        this.endEvent();
    }

    private void printParameters(Object[] parameters, ListenerElement descriptor) {
        if (parameters != null && parameters.length > 0) {
            for (int i = 0; i < parameters.length; ++i) {
                Object value = parameters[i];
                if (value != null) {
                    this.startElement("parameter", null);
                } else {
                    this.startElement("parameter", new String[][]{{"null", "true"}});
                }
                this.parameterManager.serialize((Type)descriptor.getParameters().get(i), parameters[i], this.contentHandler);
                this.endElement("parameter");
            }
        }
    }

    private void startElement(String elemntName, String[][] parameters) {
        try {
            this.contentHandler.startElement("", elemntName, elemntName, this.createAttributes(parameters));
        }
        catch (SAXException e) {
            throw new RuntimeException("Failed to send sax event", e);
        }
    }

    private void endElement(String elemntName) {
        try {
            this.contentHandler.endElement("", elemntName, elemntName);
        }
        catch (SAXException e) {
            throw new RuntimeException("Failed to send sax event", e);
        }
    }

    private Attributes createAttributes(String[][] parameters) {
        AttributesImpl attributes = new AttributesImpl();
        if (parameters != null && parameters.length > 0) {
            for (String[] entry : parameters) {
                attributes.addAttribute(null, null, entry[0], null, entry[1]);
            }
        }
        return attributes;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        ContentHandler result = null;
        if (method.getName().equals("setContentHandler")) {
            this.contentHandler = (ContentHandler)args[0];
        } else if (method.getName().equals("getContentHandler")) {
            result = this.contentHandler;
        } else if (method.getName().startsWith("begin")) {
            this.beginEvent(method.getName(), args);
        } else if (method.getName().startsWith("end")) {
            this.endEvent();
        } else if (method.getName().startsWith("on")) {
            this.onEvent(method.getName(), args);
        } else {
            throw new NoSuchMethodException(method.toGenericString());
        }
        return result;
    }
}

