/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.html;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.rendering.internal.renderer.AbstractPrintRendererFactory;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.renderer.PrintRendererFactory;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.syntax.SyntaxRegistry;
import org.xwiki.rendering.syntax.SyntaxType;

@Component(hints={"xhtmlmacro/1.0", "htmlmacro+annotatedxhtml/1.0", "htmlmacro+annotatedhtml/5.0", "htmlmacro+html/5.0", "htmlmacro+xhtml/1.0"})
@Singleton
public class HTMLMacroXHTMLRendererFactory
extends AbstractPrintRendererFactory
implements Initializable {
    public static final String PREFIX_SYNTAX = "htmlmacro+";
    private Syntax htmlMacroSyntax;
    @Inject
    private ComponentDescriptor<PrintRendererFactory> componentDescriptor;
    @Inject
    private SyntaxRegistry syntaxRegistry;

    public void initialize() throws InitializationException {
        String roleHint = this.componentDescriptor.getRoleHint();
        String originalRole = roleHint.startsWith(PREFIX_SYNTAX) ? roleHint.substring(PREFIX_SYNTAX.length()) : "xhtml/1.0";
        try {
            Syntax originalSyntax = this.syntaxRegistry.resolveSyntax(originalRole);
            this.htmlMacroSyntax = this.toMacroSyntax(originalSyntax);
        }
        catch (ParseException parseException) {
            throw new InitializationException("Couldn't resolve the original syntax " + originalRole, (Throwable)parseException);
        }
    }

    public Syntax getSyntax() {
        return this.htmlMacroSyntax;
    }

    private Syntax toMacroSyntax(Syntax originalSyntax) {
        Syntax result;
        if (Syntax.XHTML_1_0.equals((Object)originalSyntax)) {
            result = new Syntax(new SyntaxType("xhtmlmacro", "XHTML Macro"), "1.0");
        } else {
            SyntaxType type = originalSyntax.getType();
            result = new Syntax(new SyntaxType(PREFIX_SYNTAX + type.getId(), "HTML Macro " + type.getName()), originalSyntax.getVersion());
        }
        return result;
    }
}

