/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.html;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.properties.ConverterManager;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.MacroMarkerBlock;
import org.xwiki.rendering.block.RawBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.block.match.BlockMatcher;
import org.xwiki.rendering.block.match.ClassBlockMatcher;
import org.xwiki.rendering.internal.transformation.MutableRenderingContext;
import org.xwiki.rendering.internal.transformation.macro.RawBlockFilterUtils;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroContentParser;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.MacroPreparationException;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.macro.descriptor.DefaultContentDescriptor;
import org.xwiki.rendering.macro.html.HTMLMacroParameters;
import org.xwiki.rendering.renderer.PrintRenderer;
import org.xwiki.rendering.renderer.PrintRendererFactory;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.rendering.transformation.RenderingContext;
import org.xwiki.rendering.transformation.Transformation;
import org.xwiki.rendering.transformation.macro.RawBlockFilter;
import org.xwiki.rendering.transformation.macro.RawBlockFilterParameters;

@Component
@Named(value="html")
@Singleton
public class HTMLMacro
extends AbstractMacro<HTMLMacroParameters> {
    private static final String DESCRIPTION = "Inserts HTML or XHTML code into the page.";
    private static final String CONTENT_DESCRIPTION = "The HTML content to insert in the page.";
    private static final ClassBlockMatcher MACROBLOCKMATCHER = new ClassBlockMatcher(MacroBlock.class);
    @Inject
    @Named(value="htmlmacro+html/5.0")
    private PrintRendererFactory defaultHTMLRendererFactory;
    @Inject
    private MacroContentParser contentParser;
    @Inject
    private RenderingContext renderingContext;
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;
    @Inject
    private RawBlockFilterUtils rawBlockFilterUtils;
    @Inject
    private ConverterManager converter;

    public HTMLMacro() {
        super("HTML", DESCRIPTION, (ContentDescriptor)new DefaultContentDescriptor(CONTENT_DESCRIPTION), HTMLMacroParameters.class);
        this.setDefaultCategories(Set.of("Development"));
    }

    public boolean supportsInlineMode() {
        return true;
    }

    public List<Block> execute(HTMLMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        List<Block> blocks;
        if (!StringUtils.isEmpty((CharSequence)content)) {
            Syntax targetSyntax = this.getHTMLTargetSyntax();
            String normalizedContent = content;
            if (parameters.getWiki()) {
                normalizedContent = this.renderWikiSyntax(normalizedContent, context.getTransformation(), context);
            }
            RawBlock contentBlock = new RawBlock(normalizedContent, targetSyntax);
            try {
                RawBlockFilterParameters filterParameters = new RawBlockFilterParameters(context);
                filterParameters.setClean(parameters.getClean());
                for (RawBlockFilter filter : this.rawBlockFilterUtils.getRawBlockFilters()) {
                    contentBlock = filter.filter(contentBlock, filterParameters);
                }
            }
            catch (ComponentLookupException e) {
                throw new MacroExecutionException("Couldn't initialize the HTML filtering.", (Throwable)e);
            }
            blocks = List.of(contentBlock);
        } else {
            blocks = Collections.emptyList();
        }
        return blocks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String renderWikiSyntax(String content, Transformation transformation, MacroTransformationContext context) throws MacroExecutionException {
        String xhtml;
        try {
            XDOM xdom = this.contentParser.parse(content, context, false, false);
            List macros = xdom.getBlocks((BlockMatcher)MACROBLOCKMATCHER, Block.Axes.DESCENDANT);
            for (MacroBlock macro : macros) {
                if (!"html".equals(macro.getId())) continue;
                macro.setParameter("clean", "false");
            }
            MacroBlock htmlMacroBlock = context.getCurrentMacroBlock();
            MacroMarkerBlock htmlMacroMarker = new MacroMarkerBlock(htmlMacroBlock.getId(), htmlMacroBlock.getParameters(), htmlMacroBlock.getContent(), xdom.getChildren(), htmlMacroBlock.isInline());
            htmlMacroBlock.getParent().replaceChild((Block)htmlMacroMarker, (Block)htmlMacroBlock);
            try {
                ((MutableRenderingContext)this.renderingContext).transformInContext(transformation, context.getTransformationContext(), (Block)htmlMacroMarker);
            }
            finally {
                htmlMacroMarker.getParent().replaceChild((Block)htmlMacroBlock, (Block)htmlMacroMarker);
            }
            DefaultWikiPrinter printer = new DefaultWikiPrinter();
            PrintRenderer renderer = this.getRendererFactory(this.renderingContext.getTargetSyntax()).createRenderer((WikiPrinter)printer);
            for (Block block : htmlMacroMarker.getChildren()) {
                block.traverse((Listener)renderer);
            }
            xhtml = printer.toString();
        }
        catch (Exception e) {
            throw new MacroExecutionException("Failed to parse content [" + content + "].", (Throwable)e);
        }
        return xhtml;
    }

    private PrintRendererFactory getRendererFactory(Syntax targetSyntax) {
        PrintRendererFactory result = this.defaultHTMLRendererFactory;
        if (targetSyntax != null) {
            String hint = "htmlmacro+" + targetSyntax.toIdString();
            try {
                result = (PrintRendererFactory)((ComponentManager)this.componentManagerProvider.get()).getInstance(PrintRendererFactory.class, hint);
            }
            catch (ComponentLookupException componentLookupException) {
                // empty catch block
            }
        }
        return result;
    }

    private Syntax getHTMLTargetSyntax() {
        Syntax targetSyntax = this.renderingContext.getTargetSyntax();
        if (this.getRendererFactory(targetSyntax) == this.defaultHTMLRendererFactory) {
            return Syntax.HTML_5_0;
        }
        return targetSyntax;
    }

    public void prepare(MacroBlock macroBlock) throws MacroPreparationException {
        if (Boolean.TRUE.equals(this.converter.convert(Boolean.class, (Object)macroBlock.getParameter("wiki")))) {
            this.contentParser.prepareContentWiki(macroBlock);
        }
    }

    public boolean isExecutionIsolated(HTMLMacroParameters parameters, String content) {
        return !parameters.getWiki();
    }
}

