/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xstream.internal;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.ConverterLookup;
import com.thoughtworks.xstream.core.ReferenceByXPathUnmarshaller;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.mapper.Mapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SafeTreeUnmarshaller
extends ReferenceByXPathUnmarshaller {
    private static final Logger LOGGER = LoggerFactory.getLogger(SafeTreeUnmarshaller.class);

    public SafeTreeUnmarshaller(Object root, HierarchicalStreamReader reader, ConverterLookup converterLookup, Mapper mapper) {
        super(root, reader, converterLookup, mapper);
    }

    protected Object convert(Object parent, Class type, Converter converter) {
        try {
            return super.convert(parent, type, converter);
        }
        catch (Throwable e) {
            LOGGER.debug("Got unknown exception when converting object of type [{}]", (Object)type, (Object)e);
            return null;
        }
    }
}

