/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xstream.internal;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.xstream.internal.XStreamChecker;

@Component(roles={XStreamUtils.class})
@Singleton
public class XStreamUtils {
    private static final List<Class<?>> UNSERIALIZABLE_CLASSES = Arrays.asList(Logger.class, Provider.class, ComponentManager.class, OutputStream.class, InputStream.class);
    @Inject
    private List<XStreamChecker> checkers;

    public boolean isSafeType(Object obj) {
        return obj == null || obj instanceof String || obj instanceof Number || obj.getClass().isArray() || obj instanceof Enum;
    }

    public boolean isSerializable(Object item) {
        return item == null || this.isSerializable(item.getClass());
    }

    public boolean isSerializable(Field field) {
        return this.isSerializable(field.getType());
    }

    public boolean isSerializable(Class<?> itemClass) {
        for (XStreamChecker xStreamChecker : this.checkers) {
            Boolean serializable = xStreamChecker.isSerializable(itemClass);
            if (serializable == null) continue;
            return serializable;
        }
        if (Serializable.class.isAssignableFrom(itemClass)) {
            return true;
        }
        if (itemClass.isAnnotationPresent(Component.class)) {
            return false;
        }
        for (Class clazz : UNSERIALIZABLE_CLASSES) {
            if (!clazz.isAssignableFrom(itemClass)) continue;
            return false;
        }
        return true;
    }

    public static void serializeField(String name, Class<?> defaultType, Object value, HierarchicalStreamWriter writer, MarshallingContext context, Mapper mapper) {
        if (value != null) {
            writer.startNode(name);
            Class<?> actualType = value.getClass();
            if (actualType != defaultType) {
                String serializedClassName = mapper.serializedClass(actualType);
                String attributeName = mapper.aliasForSystemAttribute("class");
                if (attributeName != null) {
                    writer.addAttribute(attributeName, serializedClassName);
                }
            }
            context.convertAnother(value);
            writer.endNode();
        }
    }
}

