/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xstream.internal;

import com.thoughtworks.xstream.MarshallingStrategy;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.core.JVM;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.xstream.internal.SafeArrayConverter;
import org.xwiki.xstream.internal.SafeLogEventConverter;
import org.xwiki.xstream.internal.SafeMessageConverter;
import org.xwiki.xstream.internal.SafeReflectionProvider;
import org.xwiki.xstream.internal.SafeThrowableConverter;
import org.xwiki.xstream.internal.SafeTreeMarshallingStrategy;
import org.xwiki.xstream.internal.XStreamUtils;

@Component(roles={SafeXStream.class})
@Singleton
public class SafeXStream
extends XStream
implements Initializable {
    @Inject
    private XStreamUtils utils;

    public SafeXStream() {
        super((ReflectionProvider)new SafeReflectionProvider(JVM.newReflectionProvider()));
    }

    public void initialize() throws InitializationException {
        ((SafeReflectionProvider)this.getReflectionProvider()).setUtils(this.utils);
        this.registerConverter((Converter)new SafeArrayConverter(this));
        this.registerConverter((Converter)new SafeMessageConverter(this));
        this.registerConverter((Converter)new SafeLogEventConverter(this));
        this.registerConverter(new SafeThrowableConverter(this.getMapper(), this.getConverterLookup().lookupConverterForType(Object.class)));
        this.ignoreUnknownElements();
        this.setMarshallingStrategy((MarshallingStrategy)new SafeTreeMarshallingStrategy(this.utils));
        this.addPermission(c -> true);
    }

    public XStreamUtils getUtils() {
        return this.utils;
    }
}

