/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xml.internal.html;

import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.htmlcleaner.BaseToken;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.CommentNode;
import org.htmlcleaner.ContentNode;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.Utils;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XWikiDOMSerializer {
    private static final Pattern CDATA_PATTERN = Pattern.compile("<!\\[CDATA\\[.*(\\]\\]>|<!\\[CDATA\\[)", 32);
    private static final String CSS_COMMENT_START = "/*";
    private static final String CSS_COMMENT_END = "*/";
    private static final String JS_COMMENT = "//";
    private static final String NEW_LINE = "\n";
    private static final String SCRIPT_TAG_NAME = "script";
    private static final String STYLE_TAG_NAME = "style";
    private CleanerProperties props;
    private boolean escapeXml;

    public XWikiDOMSerializer(CleanerProperties props, boolean escapeXml) {
        this.props = props;
        this.escapeXml = escapeXml;
    }

    public Document createDOM(DocumentBuilderFactory factory, TagNode rootNode) throws ParserConfigurationException {
        Document document = factory.newDocumentBuilder().newDocument();
        Element rootElement = document.createElement(rootNode.getName());
        document.appendChild(rootElement);
        this.createSubnodes(document, rootElement, rootNode.getAllChildren());
        return document;
    }

    private void flushContent(Document document, Element element, StringBuffer bufferedContent, Object item) {
        if (bufferedContent.length() > 0 && !(item instanceof ContentNode)) {
            boolean specialCase = this.props.isUseCdataForScriptAndStyle() && this.isScriptOrStyle(element);
            String content = bufferedContent.toString();
            if (this.escapeXml && !specialCase) {
                content = Utils.escapeXml((String)content, (CleanerProperties)this.props, (boolean)true);
            } else if (specialCase) {
                content = this.processCDATABlocks(content);
            }
            if (specialCase) {
                if (SCRIPT_TAG_NAME.equalsIgnoreCase(element.getNodeName())) {
                    element.appendChild(document.createTextNode(JS_COMMENT));
                    element.appendChild(document.createCDATASection(NEW_LINE + content + NEW_LINE + JS_COMMENT));
                } else {
                    element.appendChild(document.createTextNode(CSS_COMMENT_START));
                    element.appendChild(document.createCDATASection(CSS_COMMENT_END + StringUtils.chomp((String)content) + NEW_LINE + CSS_COMMENT_START));
                    element.appendChild(document.createTextNode(CSS_COMMENT_END));
                }
            } else {
                element.appendChild(document.createTextNode(content));
            }
            bufferedContent.setLength(0);
        }
    }

    private String processCDATABlocks(String content) {
        StringBuffer result = new StringBuffer();
        Matcher matcher = CDATA_PATTERN.matcher(content);
        int cursor = 0;
        while (matcher.find()) {
            result.append(StringEscapeUtils.unescapeHtml4((String)content.substring(cursor, matcher.start())));
            result.append(content.substring(matcher.start() + 9, matcher.end() - matcher.group(1).length()));
            cursor = matcher.end() - matcher.group(1).length() + 3;
        }
        if (cursor < content.length()) {
            result.append(StringEscapeUtils.unescapeHtml4((String)content.substring(cursor)));
        }
        String contentResult = result.toString().replace("<![CDATA[", "").replace("]]>", "");
        return contentResult;
    }

    protected boolean isScriptOrStyle(Element element) {
        String tagName = element.getNodeName();
        return SCRIPT_TAG_NAME.equalsIgnoreCase(tagName) || STYLE_TAG_NAME.equalsIgnoreCase(tagName);
    }

    private void createSubnodes(Document document, Element element, List<? extends BaseToken> tagChildren) {
        StringBuffer bufferedContent = new StringBuffer();
        if (tagChildren != null) {
            for (BaseToken baseToken : tagChildren) {
                this.flushContent(document, element, bufferedContent, baseToken);
                if (baseToken instanceof CommentNode) {
                    CommentNode commentToken = (CommentNode)baseToken;
                    Comment comment = document.createComment(commentToken.getContent());
                    element.appendChild(comment);
                    continue;
                }
                if (baseToken instanceof ContentNode) {
                    ContentNode contentToken = (ContentNode)baseToken;
                    bufferedContent.append(contentToken.getContent());
                    continue;
                }
                if (baseToken instanceof TagNode) {
                    TagNode subTagNode = (TagNode)baseToken;
                    Element subelement = document.createElement(subTagNode.getName());
                    Map attributes = subTagNode.getAttributes();
                    for (Map.Entry entry : attributes.entrySet()) {
                        String attrName = (String)entry.getKey();
                        String attrValue = (String)entry.getValue();
                        if (this.escapeXml) {
                            attrValue = Utils.escapeXml((String)attrValue, (CleanerProperties)this.props, (boolean)true);
                        }
                        subelement.setAttribute(attrName, attrValue);
                    }
                    this.createSubnodes(document, subelement, subTagNode.getAllChildren());
                    element.appendChild(subelement);
                    continue;
                }
                if (!(baseToken instanceof List)) continue;
                List sublist = (List)baseToken;
                this.createSubnodes(document, element, sublist);
            }
            this.flushContent(document, element, bufferedContent, null);
        }
    }
}

