/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xml.internal.html;

import java.io.Reader;
import java.util.Arrays;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.parsers.ParserConfigurationException;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.CleanerTransformations;
import org.htmlcleaner.DoctypeToken;
import org.htmlcleaner.HtmlCleaner;
import org.htmlcleaner.ITagInfoProvider;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.TagTransformation;
import org.htmlcleaner.TrimAttributeTagTransformation;
import org.htmlcleaner.XWikiDOMSerializer;
import org.w3c.dom.Document;
import org.xwiki.component.annotation.Component;
import org.xwiki.xml.html.HTMLCleaner;
import org.xwiki.xml.html.HTMLCleanerConfiguration;
import org.xwiki.xml.html.filter.HTMLFilter;
import org.xwiki.xml.internal.html.CachedDocumentBuilderProvider;
import org.xwiki.xml.internal.html.DefaultHTMLCleanerConfiguration;
import org.xwiki.xml.internal.html.FontTagTransformation;
import org.xwiki.xml.internal.html.TrimAttributeCleanerTransformations;
import org.xwiki.xml.internal.html.XWikiHTML5TagProvider;

@Component
@Singleton
public class DefaultHTMLCleaner
implements HTMLCleaner {
    @Inject
    @Named(value="list")
    private HTMLFilter listFilter;
    @Inject
    @Named(value="listitem")
    private HTMLFilter listItemFilter;
    @Inject
    @Named(value="font")
    private HTMLFilter fontFilter;
    @Inject
    @Named(value="body")
    private HTMLFilter bodyFilter;
    @Inject
    @Named(value="attribute")
    private HTMLFilter attributeFilter;
    @Inject
    @Named(value="link")
    private HTMLFilter linkFilter;
    @Inject
    @Named(value="sanitizer")
    private HTMLFilter sanitizerFilter;
    @Inject
    private CachedDocumentBuilderProvider documentBuilderProvider;
    @Inject
    private XWikiHTML5TagProvider html5TagInfoProvider;

    @Override
    public Document clean(Reader originalHtmlContent) {
        return this.clean(originalHtmlContent, this.getDefaultConfiguration());
    }

    @Override
    public Document clean(Reader originalHtmlContent, HTMLCleanerConfiguration configuration) {
        Document result;
        TagNode cleanedNode;
        CleanerProperties cleanerProperties = this.getDefaultCleanerProperties(configuration);
        HtmlCleaner cleaner = this.isHTML5(configuration) ? new HtmlCleaner((ITagInfoProvider)this.html5TagInfoProvider, cleanerProperties) : new HtmlCleaner(cleanerProperties);
        try {
            cleanedNode = cleaner.clean(originalHtmlContent);
        }
        catch (Exception e) {
            throw new RuntimeException("Unhandled error when cleaning HTML", e);
        }
        try {
            if (this.isHTML5(configuration)) {
                cleanedNode.setDocType(new DoctypeToken("html", null, null, null));
            } else {
                cleanedNode.setDocType(new DoctypeToken("html", "PUBLIC", "-//W3C//DTD XHTML 1.0 Strict//EN", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd"));
            }
            result = new XWikiDOMSerializer(cleanerProperties).createDOM(this.documentBuilderProvider.getAvailableDocumentBuilder(), cleanedNode);
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException("Error while serializing TagNode into w3c dom.", ex);
        }
        for (HTMLFilter filter : configuration.getFilters()) {
            filter.filter(result, configuration.getParameters());
        }
        return result;
    }

    @Override
    public HTMLCleanerConfiguration getDefaultConfiguration() {
        DefaultHTMLCleanerConfiguration configuration = new DefaultHTMLCleanerConfiguration();
        configuration.setFilters(Arrays.asList(this.bodyFilter, this.listItemFilter, this.listFilter, this.fontFilter, this.attributeFilter, this.linkFilter, this.sanitizerFilter));
        return configuration;
    }

    private CleanerProperties getDefaultCleanerProperties(HTMLCleanerConfiguration configuration) {
        CleanerProperties defaultProperties = new CleanerProperties();
        defaultProperties.setOmitUnknownTags(true);
        defaultProperties.setUseEmptyElementTags(false);
        defaultProperties.setUseCdataForScriptAndStyle(true);
        defaultProperties.setIgnoreQuestAndExclam(true);
        defaultProperties.setOmitCdataOutsideScriptAndStyle(true);
        String param = configuration.getParameters().get("namespacesAware");
        boolean namespacesAware = param == null || Boolean.parseBoolean(param);
        defaultProperties.setNamespacesAware(namespacesAware);
        defaultProperties.setCleanerTransformations((CleanerTransformations)this.getDefaultCleanerTransformations(configuration));
        defaultProperties.setTranslateSpecialEntities(false);
        param = configuration.getParameters().get("useCharacterReferences");
        boolean useCharacterReferences = param != null && Boolean.parseBoolean(param);
        defaultProperties.setTransResCharsToNCR(useCharacterReferences);
        defaultProperties.setHtmlVersion(this.getHTMLVersion(configuration));
        defaultProperties.setTrimAttributeValues(false);
        defaultProperties.setRecognizeUnicodeChars(true);
        param = configuration.getParameters().get("translateSpecialEntities");
        boolean translateSpecialEntities = param != null && Boolean.parseBoolean(param);
        defaultProperties.setTranslateSpecialEntities(translateSpecialEntities);
        defaultProperties.setDeserializeEntities(true);
        defaultProperties.setOmitComments(this.isRestricted(configuration));
        return defaultProperties;
    }

    private TrimAttributeCleanerTransformations getDefaultCleanerTransformations(HTMLCleanerConfiguration configuration) {
        TagTransformation tt;
        TrimAttributeCleanerTransformations defaultTransformations = new TrimAttributeCleanerTransformations();
        if (!this.isHTML5(configuration)) {
            tt = new TagTransformation("b", "strong", false);
            defaultTransformations.addTransformation(tt);
            tt = new TagTransformation("i", "em", false);
            defaultTransformations.addTransformation(tt);
            tt = new TagTransformation("u", "ins", false);
            defaultTransformations.addTransformation(tt);
            tt = new TagTransformation("s", "del", false);
            defaultTransformations.addTransformation(tt);
        }
        tt = new TagTransformation("strike", "del", false);
        defaultTransformations.addTransformation(tt);
        tt = new TagTransformation("center", "p", false);
        tt.addAttributeTransformation("style", "text-align:center");
        defaultTransformations.addTransformation(tt);
        if (this.isHTML5(configuration)) {
            defaultTransformations.addTransformation(new FontTagTransformation());
            tt = new TrimAttributeTagTransformation("tt", "span");
            tt.addAttributeTransformation("class", "${class} monospace");
            defaultTransformations.addTransformation(tt);
        }
        if (this.isRestricted(configuration)) {
            tt = new TagTransformation("script", "pre", false);
            defaultTransformations.addTransformation(tt);
            tt = new TagTransformation("style", "pre", false);
            defaultTransformations.addTransformation(tt);
        }
        return defaultTransformations;
    }

    private boolean isHTML5(HTMLCleanerConfiguration configuration) {
        return this.getHTMLVersion(configuration) == 5;
    }

    private boolean isRestricted(HTMLCleanerConfiguration configuration) {
        String restricted = configuration.getParameters().get("restricted");
        return "true".equalsIgnoreCase(restricted);
    }

    private int getHTMLVersion(HTMLCleanerConfiguration configuration) {
        String param = configuration.getParameters().get("htmlVersion");
        int htmlVersion = 4;
        if ("5".equals(param)) {
            htmlVersion = 5;
        }
        return htmlVersion;
    }
}

