/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xml.internal.html;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;

@Component(roles={MathMLDefinitions.class})
@Singleton
public class MathMLDefinitions {
    private final Set<String> safeTags = new HashSet<String>(Arrays.asList("math", "menclose", "merror", "mfenced", "mfrac", "mglyph", "mi", "mlabeledtr", "mmultiscripts", "mn", "mo", "mover", "mpadded", "mphantom", "mroot", "mrow", "ms", "mspace", "msqrt", "mstyle", "msub", "msup", "msubsup", "mtable", "mtd", "mtext", "mtr", "munder", "munderover"));
    private final Set<String> allTags = new HashSet<String>(Arrays.asList("maction", "maligngroup", "malignmark", "mlongdiv", "mscarries", "mscarry", "msgroup", "mstack", "msline", "msrow", "semantics", "annotation", "annotation-xml", "mprescripts", "none"));
    private final Set<String> allowedAttributes;
    private final Set<String> textIntegrationPoints;

    public MathMLDefinitions() {
        this.allTags.addAll(this.safeTags);
        this.allowedAttributes = new HashSet<String>(Arrays.asList("accent", "accentunder", "align", "bevelled", "close", "columnsalign", "columnlines", "columnspan", "denomalign", "depth", "dir", "display", "displaystyle", "encoding", "fence", "frame", "height", "href", "id", "largeop", "length", "linethickness", "lspace", "lquote", "mathbackground", "mathcolor", "mathsize", "mathvariant", "maxsize", "minsize", "movablelimits", "notation", "numalign", "open", "rowalign", "rowlines", "rowspacing", "rowspan", "rspace", "rquote", "scriptlevel", "scriptminsize", "scriptsizemultiplier", "selection", "separator", "separators", "stretchy", "subscriptshift", "supscriptshift", "symmetric", "voffset", "width", "xmlns"));
        this.textIntegrationPoints = new HashSet<String>(Arrays.asList("mi", "mo", "mn", "ms", "mtext", "annotation-xml"));
    }

    public boolean isSafeTag(String tagName) {
        return this.safeTags.contains(tagName);
    }

    public boolean isMathMLTag(String tagName) {
        return this.allTags.contains(tagName);
    }

    public boolean isAllowedAttribute(String attributeName) {
        return this.allowedAttributes.contains(attributeName);
    }

    public boolean isTextOrHTMLIntegrationPoint(String tagName) {
        return this.textIntegrationPoints.contains(tagName);
    }
}

