/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xml.internal.html.filter;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.xwiki.component.annotation.Component;
import org.xwiki.xml.html.filter.AbstractHTMLFilter;
import org.xwiki.xml.internal.html.FontTagTransformation;

@Component
@Named(value="font")
@Singleton
public class FontFilter
extends AbstractHTMLFilter {
    @Override
    public void filter(Document document, Map<String, String> cleaningParameters) {
        List<Element> fontTags = this.filterDescendants(document.getDocumentElement(), new String[]{"font"});
        for (Element fontTag : fontTags) {
            Element span = document.createElement("span");
            this.moveChildren(fontTag, span);
            HashMap<String, String> attributes = new HashMap<String, String>();
            NamedNodeMap domAttributes = fontTag.getAttributes();
            for (int i = 0; i < domAttributes.getLength(); ++i) {
                Attr domAttribute = (Attr)domAttributes.item(i);
                attributes.put(domAttribute.getName(), domAttribute.getValue());
            }
            new FontTagTransformation().applyTagTransformations(attributes).forEach(span::setAttribute);
            fontTag.getParentNode().insertBefore(span, fontTag);
            fontTag.getParentNode().removeChild(fontTag);
        }
    }
}

