/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xml.internal.html;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.stability.Unstable;
import org.xwiki.xml.html.HTMLElementSanitizer;

@Component
@Singleton
@Unstable
public class DefaultHTMLElementSanitizer
implements HTMLElementSanitizer,
Initializable {
    private static final String CONFIGURATION_KEY = "xml.htmlElementSanitizer";
    private HTMLElementSanitizer implementation;
    @Inject
    @Named(value="restricted")
    private Provider<ConfigurationSource> configurationSourceProvider;
    @Inject
    private Execution execution;
    @Inject
    private Provider<ComponentManager> componentManagerProvider;
    @Inject
    private Logger logger;

    public void initialize() throws InitializationException {
        ConfigurationSource configurationSource = (ConfigurationSource)this.configurationSourceProvider.get();
        String hint = configurationSource != null ? (String)configurationSource.getProperty(CONFIGURATION_KEY, (Object)"secure") : "secure";
        try {
            this.implementation = this.loadImplementationWithSecureFallback(hint);
        }
        catch (ComponentLookupException ex) {
            throw new InitializationException("Couldn't initialize the default secure HTMLElementSanitizer", (Throwable)ex);
        }
    }

    private HTMLElementSanitizer loadImplementationWithSecureFallback(String hint) throws ComponentLookupException {
        HTMLElementSanitizer result;
        ComponentManager componentManager = (ComponentManager)this.componentManagerProvider.get();
        try {
            result = (HTMLElementSanitizer)componentManager.getInstance(HTMLElementSanitizer.class, hint);
        }
        catch (ComponentLookupException e) {
            this.logger.error("Couldn't load the configured HTMLElementSanitizer with hint [{}], falling back to the default secure implementation: {}", (Object)hint, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            result = (HTMLElementSanitizer)componentManager.getInstance(HTMLElementSanitizer.class, "secure");
        }
        return result;
    }

    private HTMLElementSanitizer getImplementation() {
        ExecutionContext context = this.execution.getContext();
        HTMLElementSanitizer result = this.implementation;
        if (context != null && context.hasProperty("xml.html.htmlElementSanitizerHint")) {
            String hint = (String)context.getProperty("xml.html.htmlElementSanitizerHint");
            try {
                result = (HTMLElementSanitizer)((ComponentManager)this.componentManagerProvider.get()).getInstance(HTMLElementSanitizer.class, hint);
            }
            catch (ComponentLookupException e) {
                this.logger.error("Couldn't load the HTMLElementSanitizer with hint [{}] from the execution context, falling back to the configured implementation: {}", (Object)hint, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
        return result;
    }

    @Override
    public boolean isElementAllowed(String elementName) {
        return this.getImplementation().isElementAllowed(elementName);
    }

    @Override
    public boolean isAttributeAllowed(String elementName, String attributeName, String value) {
        return this.getImplementation().isAttributeAllowed(elementName, attributeName, value);
    }
}

