/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xml.internal.html;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.stability.Unstable;
import org.xwiki.xml.html.HTMLElementSanitizer;
import org.xwiki.xml.internal.html.HTMLDefinitions;
import org.xwiki.xml.internal.html.HTMLElementSanitizerConfiguration;
import org.xwiki.xml.internal.html.MathMLDefinitions;
import org.xwiki.xml.internal.html.SVGDefinitions;

@Component
@Named(value="secure")
@Singleton
@Unstable
public class SecureHTMLElementSanitizer
implements HTMLElementSanitizer,
Initializable {
    public static final String HINT = "secure";
    static final Pattern IS_SCRIPT_OR_DATA = Pattern.compile("^(?:\\w+script|data):", 2);
    static final Pattern ATTR_WHITESPACE = Pattern.compile("[\\u0000-\\u0020\\u00A0\\u1680\\u180E\\u2000-\\u2029\\u205F\\u3000]");
    static final Pattern DATA_ATTR = Pattern.compile("^data-[\\-\\w.\\u00B7-\\uFFFF]");
    static final Pattern ARIA_ATTR = Pattern.compile("^aria-[\\-\\w]+$");
    static final Pattern IS_ALLOWED_URI = Pattern.compile("^(?:(?:f|ht)tps?|mailto|tel|callto|cid|xmpp):", 2);
    static final Pattern IS_NO_URI = Pattern.compile("^(?:[^a-z]|[a-z+.\\-]+(?:[^a-z+.\\-:]|$))", 2);
    @Inject
    private HTMLElementSanitizerConfiguration htmlElementSanitizerConfiguration;
    @Inject
    private HTMLDefinitions htmlDefinitions;
    @Inject
    private SVGDefinitions svgDefinitions;
    @Inject
    private MathMLDefinitions mathMLDefinitions;
    private final Set<String> extraAllowedTags;
    private final Set<String> extraAllowedAttributes;
    private final Set<String> xmlAttributes;
    private final Set<String> dataUriTags = new HashSet<String>(Arrays.asList("audio", "video", "img", "source", "image", "track"));
    private final Set<String> uriSafeAttributes = new HashSet<String>(Arrays.asList("alt", "class", "for", "id", "label", "name", "pattern", "placeholder", "role", "summary", "title", "value", "style", "xmlns"));
    private final Set<String> forbidTags;
    private final Set<String> forbidAttributes;
    private boolean allowUnknownProtocols;
    private Pattern allowedUriPattern;

    public SecureHTMLElementSanitizer() {
        this.xmlAttributes = new HashSet<String>(Arrays.asList("xlink:href", "xml:id", "xlink:title", "xml:space", "xmlns:xlink"));
        this.extraAllowedTags = new HashSet<String>();
        this.extraAllowedAttributes = new HashSet<String>();
        this.forbidTags = new HashSet<String>();
        this.forbidAttributes = new HashSet<String>();
        this.allowedUriPattern = IS_ALLOWED_URI;
    }

    public void initialize() throws InitializationException {
        this.extraAllowedTags.addAll(this.htmlElementSanitizerConfiguration.getExtraAllowedTags());
        this.extraAllowedAttributes.addAll(this.htmlElementSanitizerConfiguration.getExtraAllowedAttributes());
        this.uriSafeAttributes.addAll(this.htmlElementSanitizerConfiguration.getExtraUriSafeAttributes());
        this.dataUriTags.addAll(this.htmlElementSanitizerConfiguration.getExtraDataUriTags());
        this.allowUnknownProtocols = this.htmlElementSanitizerConfiguration.isAllowUnknownProtocols();
        this.forbidTags.addAll(this.htmlElementSanitizerConfiguration.getForbidTags());
        this.forbidAttributes.addAll(this.htmlElementSanitizerConfiguration.getForbidAttributes());
        String configuredRegexp = this.htmlElementSanitizerConfiguration.getAllowedUriRegexp();
        if (StringUtils.isNotBlank((CharSequence)configuredRegexp)) {
            this.allowedUriPattern = Pattern.compile(configuredRegexp, 2);
        }
    }

    @Override
    public boolean isElementAllowed(String elementName) {
        return !this.forbidTags.contains(elementName) && (this.extraAllowedTags.contains(elementName) || this.isElementSafe(elementName));
    }

    private boolean isElementSafe(String elementName) {
        return this.htmlDefinitions.isSafeTag(elementName) || this.svgDefinitions.isSafeTag(elementName) || this.mathMLDefinitions.isSafeTag(elementName);
    }

    @Override
    public boolean isAttributeAllowed(String elementName, String attributeName, String attributeValue) {
        boolean result = false;
        String lowerElement = elementName.toLowerCase();
        String lowerAttribute = attributeName.toLowerCase();
        if ((DATA_ATTR.matcher(lowerAttribute).find() || ARIA_ATTR.matcher(lowerAttribute).find()) && !this.forbidAttributes.contains(lowerAttribute)) {
            result = true;
        } else if (this.isAttributeAllowed(lowerAttribute) && !this.forbidAttributes.contains(lowerAttribute)) {
            result = this.isAllowedValue(lowerElement, lowerAttribute, attributeValue);
        }
        return result;
    }

    private boolean isAllowedValue(String lowercaseElementName, String lowercaseAttributeName, String attributeValue) {
        boolean result = StringUtils.isBlank((CharSequence)attributeValue);
        if (!result) {
            String valueNoWhitespace = ATTR_WHITESPACE.matcher(attributeValue).replaceAll("");
            result = this.uriSafeAttributes.contains(lowercaseAttributeName);
            result = result || IS_NO_URI.matcher(valueNoWhitespace).find();
            result = result || this.allowedUriPattern.matcher(valueNoWhitespace).find();
            result = result || this.isAllowedDataValue(lowercaseElementName, lowercaseAttributeName, attributeValue);
            result = result || this.allowUnknownProtocols && !this.isScriptOrData(attributeValue);
        }
        return result;
    }

    private boolean isAttributeAllowed(String attributeName) {
        boolean result = this.extraAllowedAttributes.contains(attributeName);
        result = result || this.htmlDefinitions.isAllowedAttribute(attributeName);
        result = result || this.svgDefinitions.isAllowedAttribute(attributeName);
        result = result || this.mathMLDefinitions.isAllowedAttribute(attributeName);
        result = result || this.xmlAttributes.contains(attributeName);
        return result;
    }

    private boolean isScriptOrData(String attributeValue) {
        return IS_SCRIPT_OR_DATA.matcher(ATTR_WHITESPACE.matcher(attributeValue).replaceAll("")).find();
    }

    private boolean isAllowedDataValue(String elementName, String attributeName, String attributeValue) {
        boolean attributeAllowsData = "src".equals(attributeName) || "xlink:href".equals(attributeName) || "href".equals(attributeName);
        return attributeAllowsData && !"script".equals(elementName) && attributeValue.startsWith("data:") && this.dataUriTags.contains(elementName);
    }
}

