/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.DomSerializer;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.Utils;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;

public class XWikiDOMSerializer
extends DomSerializer {
    private static final String HTML_QUALIFIED_NAME = "html";

    public XWikiDOMSerializer(CleanerProperties props) {
        super(props, false);
    }

    private Document createDocument(DocumentBuilder builder, TagNode rootNode) {
        Document document;
        DOMImplementation impl = builder.getDOMImplementation();
        if (rootNode.getDocType() != null) {
            String qualifiedName = rootNode.getDocType().getPart1();
            String publicId = rootNode.getDocType().getPublicId();
            String systemId = rootNode.getDocType().getSystemId();
            if (qualifiedName == null) {
                qualifiedName = HTML_QUALIFIED_NAME;
            }
            DocumentType documentType = impl.createDocumentType(qualifiedName, publicId, systemId);
            if (qualifiedName.equals("HTML")) {
                qualifiedName = HTML_QUALIFIED_NAME;
            }
            document = impl.createDocument(rootNode.getNamespaceURIOnPath(""), qualifiedName, documentType);
        } else {
            document = builder.newDocument();
            Element rootElement = document.createElement(rootNode.getName());
            document.appendChild(rootElement);
        }
        if (this.props.isAllowInvalidAttributeNames() || !this.strictErrorChecking) {
            document.setStrictErrorChecking(false);
        }
        Map attributes = rootNode.getAttributes();
        for (Map.Entry entry : attributes.entrySet()) {
            String attrName = (String)entry.getKey();
            String attrValue = (String)entry.getValue();
            if (!this.props.isAllowInvalidAttributeNames()) {
                attrName = Utils.sanitizeXmlIdentifier((String)attrName, (String)this.props.getInvalidXmlAttributeNamePrefix());
            }
            if (attrName == null || !Utils.isValidXmlIdentifier((String)attrName) && !this.props.isAllowInvalidAttributeNames()) continue;
            if (this.escapeXml) {
                attrValue = Utils.escapeXml((String)attrValue, (CleanerProperties)this.props, (boolean)true);
            }
            document.getDocumentElement().setAttribute(attrName, attrValue);
            if (!attrName.equalsIgnoreCase("id")) continue;
            document.getDocumentElement().setIdAttribute(attrName, true);
        }
        return document;
    }

    public Document createDOM(DocumentBuilder documentBuilder, TagNode rootNode) throws ParserConfigurationException {
        Document document = this.createDocument(documentBuilder, rootNode);
        this.createSubnodes(document, document.getDocumentElement(), rootNode.getAllChildren());
        return document;
    }
}

