/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xml.internal;

import java.lang.reflect.Method;
import javax.inject.Singleton;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.xml.XMLReaderFactory;

@Component
@Singleton
public class DefaultXMLReaderFactory
implements XMLReaderFactory,
Initializable {
    private Object xercesGrammarPool;

    public void initialize() throws InitializationException {
        try {
            this.xercesGrammarPool = Class.forName("org.apache.xerces.util.XMLGrammarPoolImpl").newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public XMLReader createXMLReader() throws SAXException, ParserConfigurationException {
        XMLReader xmlReader;
        try {
            Object xercesConfiguration = Class.forName("org.apache.xerces.parsers.XML11NonValidatingConfiguration").newInstance();
            Method setPropertyMethod = xercesConfiguration.getClass().getMethod("setProperty", String.class, Object.class);
            setPropertyMethod.invoke(xercesConfiguration, "http://apache.org/xml/properties/internal/grammar-pool", this.xercesGrammarPool);
            xmlReader = (XMLReader)Class.forName("org.apache.xerces.parsers.SAXParser").getConstructor(Class.forName("org.apache.xerces.xni.parser.XMLParserConfiguration")).newInstance(xercesConfiguration);
            Object secManager = Class.forName("org.apache.xerces.util.SecurityManager").newInstance();
            xmlReader.setProperty("http://apache.org/xml/properties/security-manager", secManager);
        }
        catch (Exception e) {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            try {
                parserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            }
            catch (SAXNotRecognizedException | SAXNotSupportedException secManager) {
                // empty catch block
            }
            SAXParser parser = parserFactory.newSAXParser();
            xmlReader = parser.getXMLReader();
        }
        return xmlReader;
    }
}

