/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xml.html;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.DOMBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xwiki.stability.Unstable;
import org.xwiki.xml.XMLUtils;

public final class HTMLUtils {
    private static final List<String> OMIT_ELEMENT_EXPANDING_SET = Arrays.asList("area", "base", "br", "col", "hr", "img", "input", "link", "meta", "param");

    private HTMLUtils() {
    }

    public static String toString(org.w3c.dom.Document document) {
        return HTMLUtils.toString(document, false, false);
    }

    public static String toString(org.w3c.dom.Document document, boolean omitDeclaration, boolean omitDoctype) {
        DOMBuilder builder = new DOMBuilder();
        Document jdomDoc = builder.build(document);
        Format format = Format.getRawFormat();
        format.setLineSeparator("\n");
        format.setExpandEmptyElements(true);
        format.setOmitDeclaration(omitDeclaration);
        XWikiXMLOutputter outputter = new XWikiXMLOutputter(format, omitDoctype);
        return outputter.outputString(jdomDoc);
    }

    public static void stripHTMLEnvelope(org.w3c.dom.Document document) {
        org.w3c.dom.Element root = document.getDocumentElement();
        if (root.getNodeName().equalsIgnoreCase("html")) {
            Node bodyNode = null;
            Node headNode = null;
            NodeList nodes = root.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                if (node.getNodeName().equalsIgnoreCase("head")) {
                    headNode = node;
                    continue;
                }
                if (!node.getNodeName().equalsIgnoreCase("body")) continue;
                bodyNode = node;
            }
            if (headNode != null) {
                root.removeChild(headNode);
            }
            if (bodyNode != null) {
                NodeList bodyChildrenNodes = bodyNode.getChildNodes();
                while (bodyChildrenNodes.getLength() > 0) {
                    root.insertBefore(bodyChildrenNodes.item(0), null);
                }
                root.removeChild(bodyNode);
            }
        }
    }

    public static void stripFirstElementInside(org.w3c.dom.Document document, String parentTagName, String elementTagName) {
        Node parentNode;
        Node pNode;
        NodeList parentNodes = document.getElementsByTagName(parentTagName);
        if (parentNodes.getLength() > 0 && elementTagName.equalsIgnoreCase((pNode = (parentNode = parentNodes.item(0)).getFirstChild()).getNodeName())) {
            NodeList pChildrenNodes = pNode.getChildNodes();
            while (pChildrenNodes.getLength() > 0) {
                parentNode.insertBefore(pChildrenNodes.item(0), null);
            }
            parentNode.removeChild(pNode);
        }
    }

    @Unstable
    public static String escapeElementText(String content) {
        return XMLUtils.escapeElementText(content);
    }

    public static class XWikiXMLOutputter
    extends XMLOutputter {
        private static final String CHARACTER_REFERENCE = "&amp;#[0-9]+;|&amp;#x[0-9a-fA-F]+;";
        private static final Pattern CHARACTER_REFERENCE_PATTERN = Pattern.compile("&amp;#[0-9]+;|&amp;#x[0-9a-fA-F]+;");
        private static final String AMPERSAND = "&amp;";
        private boolean omitDocType;

        public XWikiXMLOutputter(Format format, boolean omitDocType) {
            super(format);
            this.omitDocType = omitDocType;
        }

        public String escapeElementEntities(String text) {
            String result = super.escapeElementEntities(text);
            return this.cleanAmpersandEscape(result).replaceAll("&#xD;", "\r");
        }

        public String escapeAttributeEntities(String text) {
            String result = super.escapeAttributeEntities(text);
            return this.cleanAmpersandEscape(result);
        }

        private String cleanAmpersandEscape(String text) {
            StringBuilder buffer = new StringBuilder(text);
            int pos = buffer.indexOf(AMPERSAND);
            while (pos > -1 && pos < buffer.length()) {
                Matcher matcher = CHARACTER_REFERENCE_PATTERN.matcher(buffer.substring(pos));
                if (matcher.lookingAt()) {
                    buffer.replace(pos, pos + 5, "&");
                    pos = pos + matcher.end() - matcher.start() - 4;
                } else {
                    pos += 5;
                }
                pos = buffer.indexOf(AMPERSAND, pos);
            }
            return buffer.toString();
        }

        protected void printDocType(Writer out, DocType docType) throws IOException {
            if (!this.omitDocType) {
                super.printDocType(out, docType);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void printElement(Writer out, Element element, int level, XMLOutputter.NamespaceStack namespaces) throws IOException {
            boolean currentFormatPolicy = this.currentFormat.getExpandEmptyElements();
            try {
                String elementName = element.getName();
                for (String name : OMIT_ELEMENT_EXPANDING_SET) {
                    if (!name.equals(elementName)) continue;
                    this.currentFormat.setExpandEmptyElements(false);
                    break;
                }
                super.printElement(out, element, level, namespaces);
            }
            finally {
                this.currentFormat.setExpandEmptyElements(currentFormatPolicy);
            }
        }
    }
}

