/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class Sax2Dom
implements ContentHandler,
LexicalHandler {
    public static final String XML_PREFIX = "xml";
    public static final String XMLNS_PREFIX = "xmlns";
    public static final String XMLNS_STRING = "xmlns:";
    public static final String XMLNS_URI = "http://www.w3.org/2000/xmlns/";
    private final Node rootNode;
    private final Document document;
    private final Stack<Node> nodes = new Stack();
    private List<String> namespaceDecls;

    public Sax2Dom() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        this.document = factory.newDocumentBuilder().newDocument();
        this.rootNode = this.document;
    }

    public Sax2Dom(Node root) throws ParserConfigurationException {
        if (root instanceof Document) {
            this.document = (Document)root;
            this.rootNode = root;
        } else if (root != null) {
            this.document = root.getOwnerDocument();
            this.rootNode = root;
        } else {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            this.document = factory.newDocumentBuilder().newDocument();
            this.rootNode = this.document;
        }
    }

    public Node getRootNode() {
        return this.rootNode;
    }

    public Element getRootElement() {
        Element rootElement = this.rootNode instanceof Element ? (Element)this.rootNode : (this.rootNode instanceof Document ? ((Document)this.rootNode).getDocumentElement() : null);
        return rootElement;
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        Node currentNode = this.nodes.peek();
        if (currentNode != this.document) {
            String text = String.valueOf(ch, start, length);
            currentNode.appendChild(this.document.createTextNode(text));
        }
    }

    @Override
    public void startDocument() {
        this.nodes.push(this.rootNode);
    }

    @Override
    public void endDocument() {
        this.nodes.pop();
    }

    @Override
    public void startElement(String namespace, String localName, String qName, Attributes atts) {
        int i;
        Element element = this.document.createElementNS(namespace, qName);
        if (this.namespaceDecls != null) {
            int nDecls = this.namespaceDecls.size();
            for (i = 0; i < nDecls; i += 2) {
                String prefix = this.namespaceDecls.get(i);
                String uri = this.namespaceDecls.get(i + 1);
                if (StringUtils.isEmpty((CharSequence)prefix)) {
                    element.setAttributeNS(XMLNS_URI, XMLNS_PREFIX, uri);
                    continue;
                }
                element.setAttributeNS(XMLNS_URI, XMLNS_STRING + prefix, uri);
            }
            this.namespaceDecls.clear();
        }
        int nattrs = atts.getLength();
        for (i = 0; i < nattrs; ++i) {
            if (atts.getLocalName(i) == null) {
                element.setAttribute(atts.getQName(i), atts.getValue(i));
                continue;
            }
            element.setAttributeNS(atts.getURI(i), atts.getQName(i), atts.getValue(i));
        }
        this.nodes.peek().appendChild(element);
        this.nodes.push(element);
    }

    @Override
    public void endElement(String namespace, String localName, String qName) {
        this.nodes.pop();
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        if (this.namespaceDecls == null) {
            this.namespaceDecls = new ArrayList<String>(2);
        }
        this.namespaceDecls.add(prefix);
        this.namespaceDecls.add(uri);
    }

    @Override
    public void endPrefixMapping(String prefix) {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) {
    }

    @Override
    public void processingInstruction(String target, String data) {
        ProcessingInstruction pi = this.document.createProcessingInstruction(target, data);
        if (pi != null) {
            this.nodes.peek().appendChild(pi);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void skippedEntity(String name) {
    }

    @Override
    public void comment(char[] ch, int start, int length) {
        Comment comment = this.document.createComment(String.valueOf(ch, start, length));
        if (comment != null) {
            this.nodes.peek().appendChild(comment);
        }
    }

    @Override
    public void startCDATA() {
    }

    @Override
    public void endCDATA() {
    }

    @Override
    public void startEntity(String name) {
    }

    @Override
    public void endEntity(String name) {
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    @Override
    public void endDTD() {
    }
}

