/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.websocket.internal;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.websocket.HandshakeResponse;
import javax.websocket.server.HandshakeRequest;
import javax.websocket.server.ServerEndpointConfig;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.websocket.EndpointComponent;
import org.xwiki.websocket.WebSocketContext;

@Component(roles={XWikiEndpointConfigurator.class})
@Singleton
public class XWikiEndpointConfigurator
extends ServerEndpointConfig.Configurator {
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;
    @Inject
    private WebSocketContext context;

    public <T> T getEndpointInstance(Class<T> endPointClass) throws InstantiationException {
        try {
            return (T)((ComponentManager)this.componentManagerProvider.get()).getInstance(EndpointComponent.class, endPointClass.getName());
        }
        catch (ComponentLookupException e) {
            throw new InstantiationException(ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }

    public void modifyHandshake(ServerEndpointConfig config, HandshakeRequest request, HandshakeResponse response) {
        super.modifyHandshake(config, request, response);
        this.context.initialize(config, request, response);
    }
}

