/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.velocity.tools;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import java.beans.Transient;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.sf.json.JSON;
import net.sf.json.JSONException;
import net.sf.json.JSONSerializer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONTool {
    private Logger logger = LoggerFactory.getLogger(JSONTool.class);

    public String serialize(Object object) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.setVisibilityChecker((VisibilityChecker)CustomVisibilityChecker.CUSTOM);
            return mapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            this.logger.error("Failed to serialize object to JSON", (Throwable)e);
            return null;
        }
    }

    public JSON parse(String json) {
        try {
            return JSONSerializer.toJSON((Object)json);
        }
        catch (JSONException ex) {
            this.logger.info("Tried to parse invalid JSON: [{}], exception was: {}", (Object)StringUtils.abbreviate((String)json, (int)32), (Object)ex.getMessage());
            return null;
        }
    }

    private static class CustomVisibilityChecker
    extends VisibilityChecker.Std {
        protected static final CustomVisibilityChecker CUSTOM = new CustomVisibilityChecker(VisibilityChecker.Std.class.getAnnotation(JsonAutoDetect.class));

        public CustomVisibilityChecker(JsonAutoDetect ann) {
            super(ann);
        }

        public boolean isCreatorVisible(AnnotatedMember m) {
            if (m.getAnnotation(Transient.class) != null) {
                return false;
            }
            return super.isCreatorVisible(m);
        }

        public boolean isFieldVisible(Field f) {
            if (f.getAnnotation(Transient.class) != null) {
                return false;
            }
            return super.isFieldVisible(f);
        }

        public boolean isGetterVisible(Method m) {
            if (m.getAnnotation(Transient.class) != null) {
                return false;
            }
            return super.isGetterVisible(m);
        }

        public boolean isIsGetterVisible(Method m) {
            if (m.getAnnotation(Transient.class) != null) {
                return false;
            }
            return super.isIsGetterVisible(m);
        }

        public boolean isSetterVisible(Method m) {
            if (m.getAnnotation(Transient.class) != null) {
                return false;
            }
            return super.isSetterVisible(m);
        }
    }
}

