/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.velocity;

import java.io.Reader;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.velocity.Template;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;
import org.apache.velocity.runtime.resource.loader.StringResourceLoader;
import org.xwiki.stability.Unstable;

@Unstable
public class VelocityTemplate {
    private Template template = new Template();
    private Map<String, Object> templateMacros = new ConcurrentHashMap<String, Object>();

    public VelocityTemplate(String name, RuntimeServices rs) {
        if (name == null) {
            throw new NullPointerException("The name of the Velocity template must not be null");
        }
        this.template.setName(name);
        this.template.setRuntimeServices(rs);
    }

    public void compile(Reader source) {
        this.template.setResourceLoader((ResourceLoader)new SingletonResourceReader(source));
        this.template.process();
        Map macros = this.template.getMacros();
        this.templateMacros.putAll(macros);
        macros.clear();
        this.template.setResourceLoader(null);
    }

    public Template getTemplate() {
        return this.template;
    }

    public Map<String, Object> getMacros() {
        return this.templateMacros;
    }

    private static class SingletonResourceReader
    extends StringResourceLoader {
        private final Reader reader;

        SingletonResourceReader(Reader r) {
            this.reader = r;
        }

        public Reader getResourceReader(String source, String encoding) {
            return this.reader;
        }
    }
}

