/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.velocity.internal.util;

import javax.inject.Singleton;

import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;

/**
 * Utility component to check if a string contains a velocity script.
 *
 * @version $Id: 6d567662ffa78306f46b4da810ab40ba3cdc2fea $
 * @since 15.9RC1
 */
@Component(roles = VelocityDetector.class)
@Singleton
public class VelocityDetector
{
    /**
     * Checks if a string contains a velocity script.
     *
     * @param input the string to check
     * @return true if the string contains a velocity script, false otherwise
     */
    public boolean containsVelocityScript(String input)
    {
        return StringUtils.containsAny(input, '#', '$');
    }
}
