/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.velocity.introspection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.util.RuntimeServicesAware;
import org.apache.velocity.util.introspection.AbstractChainableUberspector;
import org.apache.velocity.util.introspection.Info;
import org.apache.velocity.util.introspection.VelMethod;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.properties.ConverterManager;
import org.xwiki.velocity.internal.inrospection.WrappingVelMethod;

public class MethodArgumentsUberspector
extends AbstractChainableUberspector
implements RuntimeServicesAware {
    private ConverterManager converterManager;

    public void setRuntimeServices(RuntimeServices runtimeServices) {
        super.setRuntimeServices(runtimeServices);
        ComponentManager componentManager = (ComponentManager)runtimeServices.getApplicationAttribute((Object)ComponentManager.class.getName());
        try {
            this.converterManager = (ConverterManager)componentManager.getInstance(ConverterManager.class);
        }
        catch (ComponentLookupException e) {
            this.log.warn("Failed to find an implementation for [{}]. Working in degraded mode without Velocity parameter conversion. Root cause: [{}]", (Object)ConverterManager.class.getName(), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }

    public VelMethod getMethod(Object obj, String methodName, Object[] args, Info i) {
        Object[] convertedArguments;
        VelMethod initialVelMethod;
        VelMethod velMethod = initialVelMethod = super.getMethod(obj, methodName, args, i);
        boolean shouldConvert = false;
        if (this.converterManager != null) {
            if (velMethod == null) {
                shouldConvert = true;
            } else {
                boolean sameParameterNumbers;
                Method method = velMethod.getMethod();
                boolean bl = sameParameterNumbers = method.getParameterTypes().length == args.length;
                if (!sameParameterNumbers) {
                    shouldConvert = true;
                }
            }
        }
        if (shouldConvert && (convertedArguments = this.convertArguments(obj, methodName, args)) != null) {
            velMethod = super.getMethod(obj, methodName, convertedArguments, i);
            velMethod = velMethod != null ? new ConvertingVelMethod(velMethod) : initialVelMethod;
        }
        return velMethod;
    }

    private Object[] convertArguments(Object obj, String methodName, Object[] args) {
        Iterator it = Arrays.stream(obj.getClass().getMethods()).filter(m -> this.isSupported((Method)m, methodName, args)).sorted((m1, m2) -> this.compare((Method)m1, (Method)m2, methodName, args)).iterator();
        while (it.hasNext()) {
            Method method = (Method)it.next();
            try {
                return this.convertArguments(args, method.getGenericParameterTypes(), method.isVarArgs());
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    private boolean isSupported(Method method, String methodName, Object[] args) {
        return method.getName().equalsIgnoreCase(methodName) && (method.getGenericParameterTypes().length == args.length || method.isVarArgs());
    }

    private int compare(Method method1, Method method2, String methodName, Object[] args) {
        int value = this.compareMethodNames(method1, method2, methodName);
        if (value != 0) {
            return value;
        }
        value = this.compareMethodArguments(method1, method2, methodName, args);
        if (value != 0) {
            return value;
        }
        return method1.toString().compareTo(method2.toString());
    }

    private int compareMethodNames(Method method1, Method method2, String methodName) {
        if (!method1.getName().equals(method2.getName())) {
            if (methodName.equals(method1.getName())) {
                return -1;
            }
            if (methodName.equals(method2.getName())) {
                return 1;
            }
        }
        return 0;
    }

    private int compareMethodArguments(Method method1, Method method2, String methodName, Object[] args) {
        double compatibleArtgumentsCount2;
        double compatibleArtgumentsCount1 = this.countCompatibleParameters(method1, args);
        if (compatibleArtgumentsCount1 > (compatibleArtgumentsCount2 = this.countCompatibleParameters(method2, args))) {
            return -1;
        }
        if (compatibleArtgumentsCount1 < compatibleArtgumentsCount2) {
            return 1;
        }
        if (!method1.isVarArgs() && method2.isVarArgs()) {
            return -1;
        }
        if (method1.isVarArgs() && !method2.isVarArgs()) {
            return 1;
        }
        return 0;
    }

    private double countCompatibleParameters(Method method, Object[] args) {
        double number = 0.0;
        Type[] types = method.getGenericParameterTypes();
        for (int i = 0; i < args.length && i < types.length; ++i) {
            Type type = types[i];
            Object arg = args[i];
            if (arg == null) continue;
            if (arg.getClass() == type) {
                number += 10.0;
                continue;
            }
            if (TypeUtils.isInstance((Object)arg, (Type)type)) {
                number += 1.0;
                continue;
            }
            if (!(type instanceof Class)) continue;
            Class typeClass = (Class)type;
            if (this.isPrimitive(typeClass, arg)) {
                number += 1.0;
                continue;
            }
            if (!this.isNumber(typeClass, arg)) continue;
            number += 0.5;
        }
        return number;
    }

    private boolean isPrimitive(Class typeClass, Object arg) {
        return typeClass.isPrimitive() && ClassUtils.primitiveToWrapper((Class)typeClass) == arg.getClass();
    }

    private boolean isNumber(Class typeClass, Object arg) {
        return ClassUtils.isAssignable((Class)typeClass, Number.class) && TypeUtils.isInstance((Object)arg, Number.class);
    }

    private Object[] convertArguments(Object[] arguments, Type[] parameterTypes, boolean isVarArgs) {
        Object[] convertedArguments = Arrays.copyOf(arguments, arguments.length);
        for (int i = 0; i < arguments.length; ++i) {
            Class<?> expectedType = isVarArgs && i >= parameterTypes.length - 1 ? ((Class)parameterTypes[parameterTypes.length - 1]).getComponentType() : parameterTypes[i];
            if (arguments[i] == null || TypeUtils.isInstance((Object)arguments[i], (Type)expectedType)) continue;
            convertedArguments[i] = this.converterManager.convert(expectedType, arguments[i]);
        }
        return convertedArguments;
    }

    private class ConvertingVelMethod
    extends WrappingVelMethod {
        ConvertingVelMethod(VelMethod realMethod) {
            super(realMethod);
        }

        @Override
        public Object invoke(Object o, Object[] params) throws IllegalAccessException, InvocationTargetException {
            return this.getWrappedVelMethod().invoke(o, MethodArgumentsUberspector.this.convertArguments(o, this.getWrappedVelMethod().getMethodName(), params));
        }
    }
}

