/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.velocity;

import java.util.List;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.directive.ForeachScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XWikiVelocityContext
extends VelocityContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(XWikiVelocityContext.class);
    private static final String VELOCITYCOUNT = "velocityCount";
    private static final String VELOCITYHASNEXT = "velocityHasNext";
    private final boolean logDeprecated;

    public XWikiVelocityContext() {
        this.logDeprecated = true;
    }

    public XWikiVelocityContext(Context innerContext) {
        this(innerContext, true);
    }

    public XWikiVelocityContext(Context innerContext, boolean logDeprecated) {
        super(innerContext);
        this.logDeprecated = logDeprecated;
    }

    private ForeachScope getForeachScope() {
        return (ForeachScope)this.get("foreach");
    }

    private Integer getVelocityCount() {
        ForeachScope foreachScope = this.getForeachScope();
        if (foreachScope != null) {
            this.warnDeprecatedBinding(VELOCITYCOUNT, foreachScope);
        }
        return foreachScope != null ? Integer.valueOf(foreachScope.getCount()) : null;
    }

    private Boolean getVelocityHasNext() {
        ForeachScope foreachScope = this.getForeachScope();
        if (foreachScope != null) {
            this.warnDeprecatedBinding(VELOCITYHASNEXT, foreachScope);
        }
        return foreachScope != null ? Boolean.valueOf(foreachScope.hasNext()) : null;
    }

    private void warnDeprecatedBinding(String binding, ForeachScope foreachScope) {
        if (this.logDeprecated) {
            LOGGER.warn("Deprecated binding [${}] used in [{}]", (Object)binding, (Object)foreachScope.getInfo().getTemplate());
        }
    }

    public void setMacroLibraries(List<Template> macroLibraries) {
        if (macroLibraries == null || !macroLibraries.isEmpty()) {
            super.setMacroLibraries(macroLibraries);
        }
    }

    public Object get(String key) {
        if (!this.containsKey(key)) {
            switch (key) {
                case "velocityCount": {
                    Integer value = this.getVelocityCount();
                    if (value == null) break;
                    return value;
                }
                case "velocityHasNext": {
                    Boolean value = this.getVelocityHasNext();
                    if (value == null) break;
                    return value;
                }
            }
        }
        return super.get(key);
    }
}

