/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.velocity;

import java.util.Map;
import java.util.Set;
import javax.script.Bindings;
import javax.script.ScriptContext;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.directive.Scope;
import org.xwiki.stability.Unstable;
import org.xwiki.velocity.XWikiVelocityContext;

@Unstable
public class ScriptVelocityContext
extends XWikiVelocityContext {
    private final Set<String> reservedBindings;
    private ScriptContext scriptContext;

    public ScriptVelocityContext(VelocityContext parent, Set<String> reservedBindings) {
        super((Context)parent);
        this.reservedBindings = reservedBindings;
    }

    public ScriptVelocityContext(VelocityContext parent, boolean logDeprecated, Set<String> reservedBindings) {
        super((Context)parent, logDeprecated);
        this.reservedBindings = reservedBindings;
    }

    public ScriptContext getScriptContext() {
        return this.scriptContext;
    }

    public void setScriptContext(ScriptContext scriptContext) {
        this.scriptContext = scriptContext;
        if (this.scriptContext != null) {
            this.copyScriptContext(200);
            this.copyScriptContext(100);
        }
    }

    private void copyScriptContext(int scope) {
        Bindings bindings = this.scriptContext.getBindings(scope);
        if (bindings != null) {
            for (Map.Entry entry : bindings.entrySet()) {
                Object currentValue;
                if (this.reservedBindings.contains(entry.getKey()) || (currentValue = this.get((String)entry.getKey())) instanceof Scope) continue;
                this.put((String)entry.getKey(), entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object internalPut(String key, Object value) {
        try {
            Object object = super.internalPut(key, value);
            return object;
        }
        finally {
            if (this.scriptContext != null && !this.reservedBindings.contains(key)) {
                this.scriptContext.setAttribute(key, value, 100);
            }
        }
    }

    public Object internalRemove(String key) {
        try {
            Object object = super.internalRemove(key);
            return object;
        }
        finally {
            if (this.scriptContext != null && !this.reservedBindings.contains(key)) {
                this.scriptContext.removeAttribute(key, 100);
            }
        }
    }
}

