/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.velocity.introspection;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.velocity.util.introspection.SecureIntrospectorImpl;
import org.slf4j.Logger;

public class SecureIntrospector
extends SecureIntrospectorImpl {
    private static final String GETNAME = "getname";
    private final Map<Class, Set<String>> whitelistedMethods = new HashMap<Class, Set<String>>();

    public SecureIntrospector(String[] badClasses, String[] badPackages, Logger log) {
        super(badClasses, badPackages, log);
        this.prepareWhitelistClass();
        this.prepareWhiteListFile();
    }

    private void prepareWhitelistClass() {
        Set<String> whitelist = SecureIntrospector.prepareSet(GETNAME, "getsimplename", "isarray", "isassignablefrom", "isenum", "isinstance", "isinterface", "islocalclass", "ismemberclass", "isprimitive", "issynthetic", "getenumconstants");
        this.whitelistedMethods.put(Class.class, whitelist);
    }

    private void prepareWhiteListFile() {
        Set<String> whitelist = SecureIntrospector.prepareSet("canexecute", "canread", "canwrite", "compareto", "createtempfile", "equals", "getabsolutefile", "getabsolutepath", "getcanonicalfile", "getcanonicalpath", "getfreespace", GETNAME, "getparent", "getparentfile", "getpath", "gettotalspace", "getusablespace", "hashcode", "isabsolute", "isdirectory", "isfile", "ishidden", "lastmodified", "length", "topath", "tostring", "touri", "tourl", "getclass");
        this.whitelistedMethods.put(File.class, whitelist);
    }

    protected Map<Class, Set<String>> getWhitelistedMethods() {
        return new HashMap<Class, Set<String>>(this.whitelistedMethods);
    }

    private static Set<String> prepareSet(String ... methodNames) {
        HashSet<String> result = new HashSet<String>();
        if (methodNames != null) {
            for (String methodName : methodNames) {
                result.add(methodName.toLowerCase());
            }
        }
        return result;
    }

    public boolean checkObjectExecutePermission(Class clazz, String methodName) {
        Boolean result = null;
        if (methodName != null) {
            for (Map.Entry<Class, Set<String>> classSetEntry : this.whitelistedMethods.entrySet()) {
                if (!classSetEntry.getKey().isAssignableFrom(clazz)) continue;
                result = classSetEntry.getValue().contains(methodName.toLowerCase());
                break;
            }
        }
        if (result == null) {
            result = super.checkObjectExecutePermission(clazz, methodName);
        }
        return result;
    }
}

