/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.velocity.internal;

import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Deque;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.RuntimeInstance;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.directive.StopCommand;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;
import org.apache.velocity.runtime.resource.loader.StringResourceLoader;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.velocity.VelocityConfiguration;
import org.xwiki.velocity.VelocityContextFactory;
import org.xwiki.velocity.VelocityEngine;
import org.xwiki.velocity.XWikiVelocityException;
import org.xwiki.velocity.internal.directive.TryCatchDirective;

@Component
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class DefaultVelocityEngine
implements VelocityEngine {
    private static final String ECONTEXT_TEMPLATES = "velocity.templates";
    @Inject
    private ComponentManager componentManager;
    @Inject
    private VelocityConfiguration velocityConfiguration;
    @Inject
    private VelocityContextFactory velocityContextFactory;
    @Inject
    private Execution execution;
    @Inject
    private Logger logger;
    private RuntimeInstance runtimeInstance;
    private TemplateEntry globalEntry;

    @Override
    public void initialize(Properties overridingProperties) throws XWikiVelocityException {
        RuntimeInstance runtime = new RuntimeInstance();
        runtime.setApplicationAttribute((Object)ComponentManager.class.getName(), (Object)this.componentManager);
        this.initializeProperties(runtime, this.velocityConfiguration.getProperties(), overridingProperties);
        runtime.loadDirective(TryCatchDirective.class.getName());
        try {
            runtime.init();
        }
        catch (Exception e) {
            throw new XWikiVelocityException("Cannot start the Velocity engine", e);
        }
        this.runtimeInstance = runtime;
        this.globalEntry = new TemplateEntry("");
    }

    private void initializeProperties(RuntimeInstance runtime, Properties configurationProperties, Properties overridingProperties) {
        String value;
        String key;
        Enumeration<?> e;
        runtime.setProperty("velocimacro.library.path", (Object)"");
        if (configurationProperties != null) {
            e = configurationProperties.propertyNames();
            while (e.hasMoreElements()) {
                key = e.nextElement().toString();
                if (overridingProperties != null && overridingProperties.containsKey(key)) continue;
                value = configurationProperties.getProperty(key);
                runtime.setProperty(key, (Object)value);
                this.logger.debug("Setting property [{}] = [{}]", (Object)key, (Object)value);
            }
        }
        if (overridingProperties != null) {
            e = overridingProperties.propertyNames();
            while (e.hasMoreElements()) {
                key = e.nextElement().toString();
                value = overridingProperties.getProperty(key);
                runtime.setProperty(key, (Object)value);
                this.logger.debug("Overriding property [{}] = [{}]", (Object)key, (Object)value);
            }
        }
    }

    @Override
    public boolean evaluate(Context context, Writer out, String templateName, String source) throws XWikiVelocityException {
        return this.evaluate(context, out, templateName, new StringReader(source));
    }

    @Override
    public boolean evaluate(Context context, Writer out, String namespace, Reader source) throws XWikiVelocityException {
        if (this.runtimeInstance == null) {
            throw new XWikiVelocityException("This Velocity Engine has not yet been initialized. You must call its initialize() method before you can use it.");
        }
        Resource currentResource = context instanceof VelocityContext ? ((VelocityContext)context).getCurrentResource() : null;
        try {
            TemplateEntry templateEntry = StringUtils.isNotEmpty((CharSequence)namespace) ? this.startedUsingMacroNamespaceInternal(namespace) : this.globalEntry;
            templateEntry.getTemplate().setResourceLoader((ResourceLoader)new SingletonResourceReader(source));
            templateEntry.getTemplate().process();
            templateEntry.getTemplate().merge((Context)(context != null ? context : this.velocityContextFactory.createContext()), out);
            boolean bl = true;
            return bl;
        }
        catch (StopCommand s) {
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new XWikiVelocityException(String.format("Failed to evaluate content with namespace [%s]", namespace), e);
        }
        finally {
            if (StringUtils.isNotEmpty((CharSequence)namespace)) {
                this.stoppedUsingMacroNamespace(namespace);
            }
            if (context instanceof VelocityContext) {
                ((VelocityContext)context).setCurrentResource(currentResource);
            }
            this.cleanIntrospectionCache(context);
        }
    }

    private void cleanIntrospectionCache(Context context) {
        try {
            Map introspectionCache = (Map)FieldUtils.readField((Object)context, (String)"introspectionCache", (boolean)true);
            introspectionCache.clear();
        }
        catch (IllegalAccessException e) {
            this.logger.warn("Failed to clean the Velocity context introspection cache. Root error: [{}]", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }

    @Override
    @Deprecated
    public void clearMacroNamespace(String namespace) {
    }

    @Override
    public void startedUsingMacroNamespace(String namespace) {
        this.startedUsingMacroNamespaceInternal(namespace);
    }

    private Deque<TemplateEntry> getCurrentTemplates(boolean create) {
        ExecutionContext executionContext = this.execution.getContext();
        if (executionContext == null) {
            return null;
        }
        LinkedList templates = (LinkedList)executionContext.getProperty(ECONTEXT_TEMPLATES);
        if (templates == null && create) {
            templates = new LinkedList();
            if (!executionContext.hasProperty(ECONTEXT_TEMPLATES)) {
                executionContext.newProperty(ECONTEXT_TEMPLATES).inherited().declare();
            }
            executionContext.setProperty(ECONTEXT_TEMPLATES, templates);
        }
        return templates;
    }

    private TemplateEntry startedUsingMacroNamespaceInternal(String namespace) {
        TemplateEntry templateEntry;
        Deque<TemplateEntry> templates = this.getCurrentTemplates(true);
        if (templates != null) {
            if (!templates.isEmpty() && templates.peek().getNamespace().equals(namespace)) {
                templateEntry = templates.peek();
                templateEntry.incrementCounter();
            } else {
                templateEntry = new TemplateEntry(namespace);
                templates.push(templateEntry);
            }
        } else {
            templateEntry = new TemplateEntry(namespace);
        }
        return templateEntry;
    }

    @Override
    public void stoppedUsingMacroNamespace(String namespace) {
        Deque<TemplateEntry> templates = this.getCurrentTemplates(true);
        if (templates != null) {
            if (templates.isEmpty()) {
                this.logger.warn("Impossible to pop namespace [{}] because there is no namespace in the stack", (Object)namespace);
            } else {
                this.popTemplateEntry(templates, namespace);
            }
        }
    }

    private void popTemplateEntry(Deque<TemplateEntry> templates, String namespace) {
        TemplateEntry templateEntry = templates.peek();
        if (templateEntry.getNamespace().equals(namespace)) {
            if (templateEntry.getCounter() > 1) {
                templateEntry.decrementCounter();
            } else {
                templates.pop();
            }
        } else {
            this.logger.warn("Impossible to pop namespace [{}] because current namespace is [{}]", (Object)namespace, (Object)templateEntry.getNamespace());
        }
    }

    private class TemplateEntry {
        private Template template;
        private String namespace;
        private int counter;

        TemplateEntry(String namespace) {
            this.namespace = namespace;
            this.template = new Template();
            this.template.setName(namespace);
            this.template.setRuntimeServices((RuntimeServices)DefaultVelocityEngine.this.runtimeInstance);
            this.counter = 1;
            if (DefaultVelocityEngine.this.globalEntry != null) {
                this.template.getMacros().putAll(DefaultVelocityEngine.this.globalEntry.getTemplate().getMacros());
            }
        }

        Template getTemplate() {
            return this.template;
        }

        String getNamespace() {
            return this.namespace;
        }

        int getCounter() {
            return this.counter;
        }

        int incrementCounter() {
            ++this.counter;
            return this.counter;
        }

        int decrementCounter() {
            --this.counter;
            return this.counter;
        }
    }

    private static class SingletonResourceReader
    extends StringResourceLoader {
        private final Reader reader;

        SingletonResourceReader(Reader r) {
            this.reader = r;
        }

        public Reader getResourceReader(String source, String encoding) {
            return this.reader;
        }
    }
}

