/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.velocity.internal;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.velocity.VelocityEngine;
import org.xwiki.velocity.VelocityFactory;
import org.xwiki.velocity.XWikiVelocityException;

@Component
@Singleton
public class DefaultVelocityFactory
implements VelocityFactory {
    @Inject
    private ComponentManager componentManager;
    private Map<String, VelocityEngine> velocityEngines = new ConcurrentHashMap<String, VelocityEngine>();

    @Override
    public boolean hasVelocityEngine(String key) {
        return this.velocityEngines.containsKey(key);
    }

    @Override
    public VelocityEngine getVelocityEngine(String key) {
        return this.velocityEngines.get(key);
    }

    @Override
    public VelocityEngine createVelocityEngine(String key, Properties properties) throws XWikiVelocityException {
        VelocityEngine engine;
        try {
            engine = (VelocityEngine)this.componentManager.getInstance(VelocityEngine.class);
        }
        catch (ComponentLookupException e) {
            throw new XWikiVelocityException("Failed to create Velocity Engine", e);
        }
        engine.initialize(properties);
        this.velocityEngines.put(key, engine);
        return engine;
    }

    @Override
    public VelocityEngine removeVelocityEngine(String key) {
        return this.velocityEngines.remove(key);
    }
}

