/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.velocity.introspection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.util.RuntimeServicesAware;
import org.apache.velocity.util.introspection.AbstractChainableUberspector;
import org.apache.velocity.util.introspection.Info;
import org.apache.velocity.util.introspection.VelMethod;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.properties.ConverterManager;
import org.xwiki.velocity.internal.inrospection.WrappingVelMethod;

public class MethodArgumentsUberspector
extends AbstractChainableUberspector
implements RuntimeServicesAware {
    private ConverterManager converterManager;

    public void setRuntimeServices(RuntimeServices runtimeServices) {
        super.setRuntimeServices(runtimeServices);
        ComponentManager componentManager = (ComponentManager)runtimeServices.getApplicationAttribute((Object)ComponentManager.class.getName());
        try {
            this.converterManager = (ConverterManager)componentManager.getInstance(ConverterManager.class);
        }
        catch (ComponentLookupException e) {
            this.log.warn("Failed to find an implementation for [{}]. Working in degraded mode without Velocity parameter conversion. Root cause: [{}]", (Object)ConverterManager.class.getName(), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }

    public VelMethod getMethod(Object obj, String methodName, Object[] args, Info i) {
        Object[] convertedArguments;
        VelMethod initialVelMethod;
        VelMethod velMethod = initialVelMethod = super.getMethod(obj, methodName, args, i);
        boolean shouldConvert = false;
        if (this.converterManager != null) {
            if (velMethod == null) {
                shouldConvert = true;
            } else {
                boolean sameParameterNumbers;
                Method method = velMethod.getMethod();
                boolean bl = sameParameterNumbers = method.getParameterTypes().length == args.length;
                if (!sameParameterNumbers) {
                    shouldConvert = true;
                }
            }
        }
        if (shouldConvert && (convertedArguments = this.convertArguments(obj, methodName, args)) != null) {
            velMethod = super.getMethod(obj, methodName, convertedArguments, i);
            velMethod = velMethod != null ? new ConvertingVelMethod(velMethod) : initialVelMethod;
        }
        return velMethod;
    }

    private Object[] convertArguments(Object obj, String methodName, Object[] args) {
        for (Method method : obj.getClass().getMethods()) {
            if (!method.getName().equalsIgnoreCase(methodName) || method.getGenericParameterTypes().length != args.length && !method.isVarArgs()) continue;
            try {
                return this.convertArguments(args, method.getGenericParameterTypes(), method.isVarArgs());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private Object[] convertArguments(Object[] arguments, Type[] parameterTypes, boolean isVarArgs) {
        Object[] convertedArguments = Arrays.copyOf(arguments, arguments.length);
        for (int i = 0; i < arguments.length; ++i) {
            Class<?> expectedType = isVarArgs && i >= parameterTypes.length - 1 ? ((Class)parameterTypes[parameterTypes.length - 1]).getComponentType() : parameterTypes[i];
            if (arguments[i] == null || TypeUtils.isInstance((Object)arguments[i], (Type)expectedType)) continue;
            convertedArguments[i] = this.converterManager.convert(expectedType, arguments[i]);
        }
        return convertedArguments;
    }

    private class ConvertingVelMethod
    extends WrappingVelMethod {
        ConvertingVelMethod(VelMethod realMethod) {
            super(realMethod);
        }

        @Override
        public Object invoke(Object o, Object[] params) throws IllegalAccessException, InvocationTargetException {
            return this.getWrappedVelMethod().invoke(o, MethodArgumentsUberspector.this.convertArguments(o, this.getWrappedVelMethod().getMethodName(), params));
        }
    }
}

