/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.velocity.internal;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.management.JMXBeanRegistration;
import org.xwiki.velocity.VelocityEngine;
import org.xwiki.velocity.VelocityFactory;
import org.xwiki.velocity.XWikiVelocityException;
import org.xwiki.velocity.internal.jmx.JMXVelocityEngine;

@Component
@Singleton
public class DefaultVelocityFactory
implements VelocityFactory {
    private static final String MBEANNAME_PREFIX = "type=Velocity,domain=Engines,name=";
    @Inject
    private ComponentManager componentManager;
    @Inject
    private JMXBeanRegistration jmxRegistration;
    private Map<String, VelocityEngine> velocityEngines = new ConcurrentHashMap<String, VelocityEngine>();

    @Override
    public boolean hasVelocityEngine(String key) {
        return this.velocityEngines.containsKey(key);
    }

    @Override
    public VelocityEngine getVelocityEngine(String key) {
        return this.velocityEngines.get(key);
    }

    @Override
    public VelocityEngine createVelocityEngine(String key, Properties properties) throws XWikiVelocityException {
        VelocityEngine engine;
        try {
            engine = (VelocityEngine)this.componentManager.getInstance(VelocityEngine.class);
        }
        catch (ComponentLookupException e) {
            throw new XWikiVelocityException("Failed to create Velocity Engine", e);
        }
        engine.initialize(properties);
        this.velocityEngines.put(key, engine);
        JMXVelocityEngine mbean = new JMXVelocityEngine(engine);
        this.jmxRegistration.registerMBean((Object)mbean, MBEANNAME_PREFIX + this.toValidName(key));
        return engine;
    }

    @Override
    public VelocityEngine removeVelocityEngine(String key) {
        VelocityEngine engine = this.velocityEngines.remove(key);
        if (engine != null) {
            this.jmxRegistration.unregisterMBean(MBEANNAME_PREFIX + this.toValidName(key));
        }
        return engine;
    }

    private String toValidName(String name) {
        return name.replaceAll("[,=:\\'\\\"]", "_");
    }
}

