/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.velocity.internal;

import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.velocity.tools.generic.ListTool;
import org.apache.velocity.tools.generic.MathTool;
import org.apache.velocity.tools.generic.NumberTool;
import org.apache.velocity.tools.generic.SortTool;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.text.StringUtils;
import org.xwiki.velocity.VelocityConfiguration;
import org.xwiki.velocity.internal.util.RestrictParseLocationEventHandler;
import org.xwiki.velocity.introspection.DeprecatedCheckUberspector;
import org.xwiki.velocity.introspection.MethodArgumentsUberspector;
import org.xwiki.velocity.introspection.SecureUberspector;
import org.xwiki.velocity.tools.CollectionsTool;
import org.xwiki.velocity.tools.ComparisonDateTool;
import org.xwiki.velocity.tools.EscapeTool;
import org.xwiki.velocity.tools.JSONTool;
import org.xwiki.velocity.tools.RegexTool;
import org.xwiki.velocity.tools.URLTool;
import org.xwiki.velocity.tools.nio.NIOTool;

@Component
@Singleton
public class DefaultVelocityConfiguration
implements Initializable,
VelocityConfiguration {
    private static final String PREFIX = "velocity.";
    protected Properties defaultTools = new Properties();
    @Inject
    private ConfigurationSource configuration;
    private Properties defaultProperties = new Properties();

    public void initialize() throws InitializationException {
        this.defaultTools.setProperty("listtool", ListTool.class.getName());
        this.defaultTools.setProperty("numbertool", NumberTool.class.getName());
        this.defaultTools.setProperty("datetool", ComparisonDateTool.class.getName());
        this.defaultTools.setProperty("mathtool", MathTool.class.getName());
        this.defaultTools.setProperty("sorttool", SortTool.class.getName());
        this.defaultTools.setProperty("escapetool", EscapeTool.class.getName());
        this.defaultTools.setProperty("regextool", RegexTool.class.getName());
        this.defaultTools.setProperty("collectionstool", CollectionsTool.class.getName());
        this.defaultTools.setProperty("stringtool", StringUtils.class.getName());
        this.defaultTools.setProperty("jsontool", JSONTool.class.getName());
        this.defaultTools.setProperty("urltool", URLTool.class.getName());
        this.defaultTools.setProperty("exceptiontool", ExceptionUtils.class.getName());
        this.defaultTools.setProperty("niotool", NIOTool.class.getName());
        this.defaultProperties.setProperty("directive.set.null.allowed", Boolean.TRUE.toString());
        this.defaultProperties.setProperty("velocimacro.messages.on", Boolean.FALSE.toString());
        this.defaultProperties.setProperty("velocimacro.max.depth", "100");
        this.defaultProperties.setProperty("resource.manager.logwhenfound", Boolean.FALSE.toString());
        this.defaultProperties.setProperty("velocimacro.permissions.allow.inline.local.scope", Boolean.TRUE.toString());
        this.defaultProperties.setProperty("eventhandler.include.class", RestrictParseLocationEventHandler.class.getName());
        this.defaultProperties.setProperty("runtime.introspector.uberspect", StringUtils.join((Object[])new String[]{SecureUberspector.class.getName(), DeprecatedCheckUberspector.class.getName(), MethodArgumentsUberspector.class.getName()}, (char)','));
        this.defaultProperties.setProperty("template.provide.scope.control", Boolean.TRUE.toString());
        this.defaultProperties.setProperty("macro.provide.scope.control", Boolean.TRUE.toString());
    }

    @Override
    public Properties getProperties() {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.defaultProperties);
        props.putAll((Map<?, ?>)((Map)this.configuration.getProperty("velocity.properties", Properties.class)));
        return props;
    }

    @Override
    public Properties getTools() {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.defaultTools);
        props.putAll((Map<?, ?>)((Map)this.configuration.getProperty("velocity.tools", Properties.class)));
        return props;
    }
}

