/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.velocity.tools;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.BCodec;
import org.apache.commons.codec.net.QCodec;
import org.apache.commons.codec.net.QuotedPrintableCodec;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.velocity.tools.CSSIdentifierSerializer;
import org.xwiki.xml.XMLUtils;

public class EscapeTool
extends org.apache.velocity.tools.generic.EscapeTool {
    private static final Logger LOGGER = LoggerFactory.getLogger(EscapeTool.class);
    private static final String EQUALS = "=";
    private static final String AND = "&";

    public String xml(Object content) {
        return XMLUtils.escape((Object)content);
    }

    public String json(Object string) {
        if (string == null) {
            return null;
        }
        return StringEscapeUtils.escapeJson((String)String.valueOf(string));
    }

    public String quotedPrintable(Object content) {
        if (content != null) {
            try {
                return new QuotedPrintableCodec().encode(String.valueOf(content));
            }
            catch (EncoderException encoderException) {
                // empty catch block
            }
        }
        return null;
    }

    public String q(Object content) {
        if (content != null) {
            try {
                return new QCodec().encode(String.valueOf(content)).replace(' ', '_');
            }
            catch (EncoderException encoderException) {
                // empty catch block
            }
        }
        return null;
    }

    public String b(Object content) {
        if (content != null) {
            try {
                return new BCodec().encode(String.valueOf(content));
            }
            catch (EncoderException encoderException) {
                // empty catch block
            }
        }
        return null;
    }

    public String url(Map<String, ?> parametersMap) {
        StringBuilder queryStringBuilder = new StringBuilder();
        for (Map.Entry<String, ?> entry : parametersMap.entrySet()) {
            Object values;
            if (entry.getKey() == null) continue;
            String cleanKey = this.url(entry.getKey());
            Object mapValues = entry.getValue();
            if (mapValues != null && mapValues.getClass().isArray()) {
                for (Object value : values = (Object[])mapValues) {
                    this.addQueryStringPair(cleanKey, value, queryStringBuilder);
                }
                continue;
            }
            if (mapValues != null && Collection.class.isAssignableFrom(mapValues.getClass())) {
                values = (Collection)mapValues;
                Iterator iterator = values.iterator();
                while (iterator.hasNext()) {
                    Object value = iterator.next();
                    this.addQueryStringPair(cleanKey, value, queryStringBuilder);
                }
                continue;
            }
            this.addQueryStringPair(cleanKey, mapValues, queryStringBuilder);
        }
        return queryStringBuilder.toString();
    }

    private void addQueryStringPair(String cleanKey, Object rawValue, StringBuilder queryStringBuilder) {
        String valueAsString = rawValue == null ? "" : String.valueOf(rawValue);
        String cleanValue = this.url(valueAsString);
        if (queryStringBuilder.length() != 0) {
            queryStringBuilder.append(AND);
        }
        queryStringBuilder.append(cleanKey).append(EQUALS).append(cleanValue);
    }

    public String css(String identifier) {
        try {
            return new CSSIdentifierSerializer().serialize(identifier);
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("Failed to escape CSS identifier. {}", (Object)e.getMessage());
            return null;
        }
    }

    public String url(Object string) {
        String encodedURL = null;
        if (string != null) {
            try {
                encodedURL = URLEncoder.encode(String.valueOf(string), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Missing charset [UTF-8]", e);
            }
            encodedURL = encodedURL.replaceAll("\\+", "%20");
        }
        return encodedURL;
    }
}

