/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.tool.xar;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class XWikiXMLWriter
extends XMLWriter {
    private boolean useFormat;

    public XWikiXMLWriter(OutputStream output) throws UnsupportedEncodingException {
        super(output);
    }

    public XWikiXMLWriter(OutputStream output, OutputFormat format) throws UnsupportedEncodingException {
        super(output, format);
        this.useFormat = true;
    }

    protected void writeComment(String text) throws IOException {
        super.writeComment(text);
        if (text.contains("See the NOTICE file distributed with this work for additional")) {
            this.println();
        }
    }

    protected void writeNodeText(Node node) throws IOException {
        if (this.useFormat && node.getText().trim().length() == 0) {
            boolean containsNonTextNode = false;
            for (Object object : node.getParent().content()) {
                Node objectNode = (Node)object;
                if (objectNode.getNodeType() == 3) continue;
                containsNonTextNode = true;
                break;
            }
            if (!containsNonTextNode) {
                super.writeNodeText(node);
            }
        } else {
            super.writeNodeText(node);
        }
    }

    protected void writePrintln() throws IOException {
        if (this.useFormat) {
            this.writer.write(this.getOutputFormat().getLineSeparator());
        }
    }
}

