/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.tool.xar;

import java.io.File;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.artifact.resolver.filter.TypeArtifactFilter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.codehaus.plexus.archiver.zip.ZipUnArchiver;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;
import org.codehaus.plexus.components.io.fileselectors.IncludeExcludeFileSelector;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.xwiki.tool.xar.internal.XWikiDocument;

abstract class AbstractXARMojo
extends AbstractMojo {
    protected static final String PACKAGE_XML = "package.xml";
    protected static final String FILES_TAG = "files";
    protected static final String FILE_TAG = "file";
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final String[] DEFAULT_EXCLUDES = new String[]{"**/META-INF/**"};
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/*.xml"};
    protected String[] includes;
    protected String[] excludes;
    protected MavenProject project;
    protected String encoding = "UTF-8";
    protected List<ArtifactRepository> remoteRepos;
    protected MavenProjectBuilder mavenProjectBuilder;
    protected ArtifactFactory factory;
    protected ArtifactResolver resolver;
    private File outputBuildDirectory;
    private ArtifactRepository local;

    AbstractXARMojo() {
    }

    protected String[] getIncludes() {
        if (this.includes != null && this.includes.length > 0) {
            return this.includes;
        }
        return DEFAULT_INCLUDES;
    }

    protected String[] getExcludes() {
        if (this.excludes != null && this.excludes.length > 0) {
            return this.excludes;
        }
        return DEFAULT_EXCLUDES;
    }

    protected void unpack(File file, File location, String logName, boolean overwrite, String[] includes, String[] excludes) throws MojoExecutionException {
        try {
            FileSelector[] selectors;
            ZipUnArchiver unArchiver = new ZipUnArchiver();
            unArchiver.setEncoding(this.encoding);
            unArchiver.enableLogging((Logger)new ConsoleLogger(3, logName));
            unArchiver.setSourceFile(file);
            unArchiver.setDestDirectory(location);
            IncludeExcludeFileSelector fs = new IncludeExcludeFileSelector();
            fs.setIncludes(includes);
            fs.setExcludes(excludes);
            unArchiver.setOverwrite(overwrite);
            if (!overwrite) {
                IncludeExcludeFileSelector fs2 = new IncludeExcludeFileSelector();
                fs2.setExcludes(new String[]{PACKAGE_XML});
                selectors = new FileSelector[]{fs, fs2};
            } else {
                selectors = new FileSelector[]{fs};
            }
            unArchiver.setFileSelectors(selectors);
            unArchiver.extract();
        }
        catch (Exception e) {
            throw new MojoExecutionException(String.format("Error unpacking file [%s] to [%s]", file, location), e);
        }
    }

    protected void unpackXARToOutputDirectory(Artifact artifact, String[] includes, String[] excludes) throws MojoExecutionException {
        if (!this.outputBuildDirectory.exists()) {
            this.outputBuildDirectory.mkdirs();
        }
        File file = artifact.getFile();
        this.unpack(file, this.outputBuildDirectory, "XAR Plugin", false, includes, excludes);
    }

    public MavenProject getProject() {
        return this.project;
    }

    protected Set<Artifact> resolveArtifactDependencies(Artifact artifact) throws ArtifactResolutionException, ArtifactNotFoundException, ProjectBuildingException, InvalidDependencyVersionException {
        Artifact pomArtifact = this.factory.createArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), "", "pom");
        MavenProject pomProject = this.mavenProjectBuilder.buildFromRepository(pomArtifact, this.remoteRepos, this.local);
        return this.resolveDependencyArtifacts(pomProject);
    }

    protected Set<Artifact> resolveDependencyArtifacts(MavenProject pomProject) throws ArtifactResolutionException, ArtifactNotFoundException, InvalidDependencyVersionException {
        AndArtifactFilter filters = new AndArtifactFilter();
        filters.add((ArtifactFilter)new TypeArtifactFilter("xar"));
        filters.add((ArtifactFilter)new ScopeArtifactFilter("runtime"));
        Set artifacts = pomProject.createArtifacts(this.factory, "test", (ArtifactFilter)filters);
        for (Artifact artifact : artifacts) {
            this.resolver.resolve(artifact, this.remoteRepos, this.local);
        }
        return artifacts;
    }

    protected XWikiDocument getDocFromXML(File file) {
        XWikiDocument doc;
        try {
            doc = new XWikiDocument();
            doc.fromXML(file);
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)String.format("Failed to parse [%s], skipping it. The error was [%s]", file.getAbsolutePath(), e.getMessage()));
            doc = null;
        }
        return doc;
    }

    protected File getResourcesDirectory() {
        String resourcesLocation = (this.project.getBasedir().getAbsolutePath() + "/src/main/resources").replace("/", File.separator);
        File resourcesDir = new File(resourcesLocation);
        return resourcesDir;
    }
}

