/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.tool.xar;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.twdata.maven.mojoexecutor.MojoExecutor;
import org.xwiki.tool.xar.AbstractVerifyMojo;
import org.xwiki.tool.xar.XWikiXMLWriter;

public class FormatMojo
extends AbstractVerifyMojo {
    private MavenProject mavenProject;
    private MavenSession mavenSession;
    private BuildPluginManager pluginManager;
    private boolean pretty = true;
    private boolean formatLicense;
    private String commonsVersion;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.getProject().getPackaging().equals("xar") || this.force) {
            this.getLog().info((CharSequence)"Formatting XAR XML files...");
            Collection<File> xmlFiles = this.getXARXMLFiles();
            for (File file : xmlFiles) {
                try {
                    this.format(file, this.guessDefaultLanguage(file, xmlFiles));
                }
                catch (Exception e) {
                    throw new MojoExecutionException(String.format("Failed to format file [%s]", file), e);
                }
            }
            if (this.formatLicense) {
                this.getLog().info((CharSequence)"Adding missing XAR XML license headers...");
                this.formatLicense();
            }
        } else {
            this.getLog().info((CharSequence)"Not a XAR module, skipping reformatting...");
        }
    }

    private void formatLicense() throws MojoExecutionException {
        Dependency dep = new Dependency();
        dep.setGroupId("org.xwiki.commons");
        dep.setArtifactId("xwiki-commons-tool-verification-resources");
        dep.setVersion(this.getXWikiCommonsVersion());
        Plugin licensePlugin = MojoExecutor.plugin((String)MojoExecutor.groupId((String)"com.mycila"), (String)MojoExecutor.artifactId((String)"license-maven-plugin"), (String)MojoExecutor.version((String)"2.6"));
        licensePlugin.setDependencies(Collections.singletonList(dep));
        MojoExecutor.executeMojo((Plugin)licensePlugin, (String)MojoExecutor.goal((String)"format"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"header"), (String)"license.txt"), MojoExecutor.element((String)MojoExecutor.name((String)"strictCheck"), (String)"true"), MojoExecutor.element((String)MojoExecutor.name((String)"headerDefinitions"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"headerDefinition"), (String)"license-xml-definition.xml")}), MojoExecutor.element((String)MojoExecutor.name((String)"includes"), (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"include"), (String)"src/main/resources/**/*.xml")})}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.mavenSession, (BuildPluginManager)this.pluginManager));
    }

    private void format(File file, String defaultLanguage) throws Exception {
        XWikiXMLWriter writer;
        SAXReader reader = new SAXReader();
        Document domdoc = reader.read(file);
        this.format(domdoc, defaultLanguage);
        if (this.pretty) {
            OutputFormat format = new OutputFormat("  ", true, "UTF-8");
            format.setExpandEmptyElements(false);
            writer = new XWikiXMLWriter(new FileOutputStream(file), format);
        } else {
            writer = new XWikiXMLWriter(new FileOutputStream(file));
        }
        writer.write(domdoc);
        writer.close();
        String parentName = file.getParentFile().getName();
        this.getLog().info((CharSequence)String.format("  Formatting [%s/%s]... ok", parentName, file.getName()));
    }

    private void format(Document domdoc, String defaultLanguage) throws Exception {
        Element element;
        Node node = domdoc.selectSingleNode("xwikidoc/author");
        if (node != null) {
            node.setText("xwiki:XWiki.Admin");
        }
        if ((node = domdoc.selectSingleNode("xwikidoc/contentAuthor")) != null) {
            node.setText("xwiki:XWiki.Admin");
        }
        if ((node = domdoc.selectSingleNode("xwikidoc/creator")) != null) {
            node.setText("xwiki:XWiki.Admin");
        }
        if ((node = domdoc.selectSingleNode("xwikidoc/version")) != null) {
            node.setText("1.1");
        }
        if ((node = domdoc.selectSingleNode("xwikidoc/minorEdit")) != null) {
            node.setText("false");
        }
        if ((element = (Element)domdoc.selectSingleNode("xwikidoc/defaultLanguage")) != null) {
            if (StringUtils.isEmpty((CharSequence)defaultLanguage)) {
                this.removeContent(element);
            } else {
                element.setText(defaultLanguage);
            }
        }
        if ((element = (Element)domdoc.selectSingleNode("xwikidoc/comment")) != null) {
            this.removeContent(element);
        }
    }

    private void removeContent(Element element) {
        if (element.hasContent()) {
            ((Node)element.content().get(0)).detach();
        }
    }

    private String getXWikiCommonsVersion() {
        String version = this.commonsVersion;
        if (version == null) {
            version = this.project.getVersion();
        }
        return version;
    }
}

