/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.tool.xar;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.xwiki.tool.xar.AbstractVerifyMojo;
import org.xwiki.tool.xar.XWikiDocument;

public class VerifyMojo
extends AbstractVerifyMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.getProject().getPackaging().equals("xar") && !this.force) {
            this.getLog().info((CharSequence)"Not a XAR module, skipping validity check...");
            return;
        }
        this.getLog().info((CharSequence)"Checking validity of XAR XML files...");
        boolean hasErrors = false;
        for (File file : this.getXARXMLFiles()) {
            String parentName = file.getParentFile().getName();
            XWikiDocument xdoc = this.getDocFromXML(file);
            ArrayList<String> errors = new ArrayList<String>();
            if (!xdoc.getEncoding().equals("UTF-8")) {
                errors.add(String.format("Encoding must be [UTF-8] but was [%s]", xdoc.getEncoding()));
            }
            this.verifyAuthor(errors, xdoc.getAuthor(), String.format("Author must be [%s] but was [%s]", "xwiki:XWiki.Admin", xdoc.getAuthor()));
            this.verifyAuthor(errors, xdoc.getContentAuthor(), String.format("Content Author must be [%s] but was [%s]", "xwiki:XWiki.Admin", xdoc.getContentAuthor()));
            this.verifyAuthor(errors, xdoc.getCreator(), String.format("Creator must be [%s] but was [%s]", "xwiki:XWiki.Admin", xdoc.getCreator()));
            if (!(!StringUtils.isEmpty((String)xdoc.getParent()) || xdoc.getSpace().equals("Main") && xdoc.getName().equals("WebHome"))) {
                errors.add("Parent must not be empty");
            }
            if (!xdoc.getVersion().equals("1.1")) {
                errors.add(String.format("Version must be [%s] but was [%s]", "1.1", xdoc.getVersion()));
            }
            if (xdoc.getComment().length() != 0) {
                errors.add(String.format("Comment must be empty but was [%s]", xdoc.getComment()));
            }
            if (!xdoc.getMinorEdit().equals("false")) {
                errors.add(String.format("Minor edit must always be [false] but was [%s]", xdoc.getMinorEdit()));
            }
            if (xdoc.getDefaultLanguage().length() != 0) {
                errors.add(String.format("Default Language must be empty but was [%s]", xdoc.getDefaultLanguage()));
            }
            if (errors.isEmpty()) {
                this.getLog().info((CharSequence)String.format("  Verifying [%s/%s]... ok", parentName, file.getName()));
                continue;
            }
            this.getLog().info((CharSequence)String.format("  Verifying [%s/%s]... errors", parentName, file.getName()));
            for (String error : errors) {
                this.getLog().info((CharSequence)String.format("  - %s", error));
            }
            hasErrors = true;
        }
        if (hasErrors) {
            throw new MojoFailureException("There are errors in the XAR XML files!");
        }
    }

    private void verifyAuthor(List<String> errors, String author, String message) {
        if (!author.equals("xwiki:XWiki.Admin")) {
            errors.add(message);
        }
    }
}

