/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.tool.checkstyle;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import org.apache.commons.lang3.StringUtils;

public class SinceFormatCheck
extends AbstractCheck {
    private String packageName;
    private String classOrInterfaceName;

    public int[] getDefaultTokens() {
        return new int[]{16, 15, 14, 9};
    }

    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 16: {
                FullIdent ident = FullIdent.createFullIdent((DetailAST)ast.getLastChild().getPreviousSibling());
                this.packageName = ident.getText();
                return;
            }
            case 14: 
            case 15: {
                this.classOrInterfaceName = ast.findFirstToken(58).getText();
            }
        }
        String elementName = ast.findFirstToken(58).getText();
        FileContents contents = this.getFileContents();
        TextBlock javadoc = contents.getJavadocBefore(ast.getLineNo());
        if (javadoc != null) {
            for (String javadocLine : javadoc.getText()) {
                int pos = javadocLine.indexOf("@since");
                if (pos <= -1) continue;
                String text = javadocLine.substring(pos + "@since".length() + 1);
                if (!StringUtils.containsAny((CharSequence)text, (char[])new char[]{',', '/', '\\', ';', ':', '+'})) continue;
                this.log(ast.getLineNo(), ast.getColumnNo(), String.format("There must be only a single version per @since tag for [%s]. Got [%s]", this.computeElementName(elementName), text), new Object[0]);
                return;
            }
        }
    }

    private String computeElementName(String annotatedElementName) {
        return String.format("%s.%s%s", this.packageName, this.classOrInterfaceName, annotatedElementName.equals(this.classOrInterfaceName) ? "" : "." + annotatedElementName + "()");
    }
}

