/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.tool.checkstyle;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class UnstableAnnotationCheck
extends AbstractCheck {
    private String packageName;
    private String classOrInterfaceName;
    private String currentVersion;
    private int currentVersionMajor;

    public int[] getDefaultTokens() {
        return new int[]{16, 15, 14, 9};
    }

    public void setCurrentVersion(String currentVersion) throws CheckstyleException {
        if (currentVersion != null && !currentVersion.isEmpty()) {
            this.currentVersion = currentVersion;
            this.currentVersionMajor = this.extractMajor(currentVersion);
            if (this.currentVersionMajor == -1) {
                throw new CheckstyleException("The passed version [" + this.currentVersionMajor + "] must be of the type Major.* (e.g. 7.0-SNAPSHOT)");
            }
        }
    }

    public void visitToken(DetailAST ast) {
        if (this.currentVersion == null) {
            return;
        }
        switch (ast.getType()) {
            case 16: {
                FullIdent ident = FullIdent.createFullIdent((DetailAST)ast.getLastChild().getPreviousSibling());
                this.packageName = ident.getText();
                break;
            }
            case 14: 
            case 15: {
                this.classOrInterfaceName = ast.findFirstToken(58).getText();
            }
        }
        if (AnnotationUtility.containsAnnotation((DetailAST)ast)) {
            DetailAST holder = AnnotationUtility.getAnnotationHolder((DetailAST)ast);
            for (DetailAST annotation : this.findAllTokens(holder, 159)) {
                String annotationName = annotation.findFirstToken(58).getText();
                if (!annotationName.equals("Unstable")) continue;
                FileContents contents = this.getFileContents();
                String annotatedElementName = ast.findFirstToken(58).getText();
                List<Object> sinceVersions = Collections.emptyList();
                TextBlock cmt = contents.getJavadocBefore(ast.getLineNo());
                if (cmt != null) {
                    sinceVersions = this.extractSinceVersionsFromJavadoc(cmt.getText(), annotation, annotatedElementName);
                }
                if (sinceVersions.isEmpty()) {
                    this.log(annotation.getLineNo(), annotation.getColumnNo(), String.format("There is an @Unstable annotation for [%s] but the @since javadoc tag is missing, you must add it!", this.computeElementName(annotatedElementName)), new Object[0]);
                    return;
                }
                for (String sinceVersion : sinceVersions) {
                    this.checkSingleSinceVersion(sinceVersion, annotation, annotatedElementName);
                }
            }
        }
    }

    private void checkSingleSinceVersion(String sinceVersion, DetailAST annotation, String annotatedElementName) {
        int sinceMajor = this.extractMajor(sinceVersion);
        if (sinceMajor == -1) {
            this.log(annotation.getLineNo(), annotation.getColumnNo(), String.format("The @since version [%s] must be of the type Major.* (e.g. 7.0-SNAPSHOT)", sinceVersion), new Object[0]);
            return;
        }
        if (this.currentVersionMajor - 2 >= sinceMajor) {
            this.log(annotation.getLineNo(), annotation.getColumnNo(), String.format("The @Unstable annotation for [%s] must be removed since it''s been there for more than a full development cycle (was introduced in [%s] and current version is [%s])", this.computeElementName(annotatedElementName), sinceVersion, this.currentVersion), new Object[0]);
        }
    }

    private String computeElementName(String annotatedElementName) {
        return String.format("%s.%s%s", this.packageName, this.classOrInterfaceName, annotatedElementName.equals(this.classOrInterfaceName) ? "" : "." + annotatedElementName + "()");
    }

    private List<String> extractSinceVersionsFromJavadoc(String[] javadocLines, DetailAST annotation, String annotatedElementName) {
        ArrayList<String> sinceVersions = new ArrayList<String>();
        for (String javadocLine : javadocLines) {
            int pos = javadocLine.indexOf("@since");
            if (pos <= -1) continue;
            String sinceVersion = javadocLine.substring(pos + "@since".length() + 1);
            sinceVersions.add(sinceVersion);
        }
        return sinceVersions;
    }

    private int extractMajor(String version) {
        int major;
        if (version == null) {
            return -1;
        }
        int pos = version.indexOf(".");
        if (pos > -1) {
            try {
                major = Integer.parseInt(version.substring(0, pos));
            }
            catch (NumberFormatException e) {
                major = -1;
            }
        } else {
            major = -1;
        }
        return major;
    }

    public List<DetailAST> findAllTokens(DetailAST ast, int aType) {
        DetailAST firstToken;
        ArrayList<DetailAST> results = new ArrayList<DetailAST>();
        DetailAST token = firstToken = ast.findFirstToken(aType);
        while (token != null) {
            results.add(token);
            if ((token = token.getNextSibling()) != null && token.getType() == aType) continue;
            break;
        }
        return results;
    }
}

