/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.tool.checkstyle;

import com.google.common.collect.Sets;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FastStack;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.checks.CheckUtils;
import java.util.Set;

public abstract class AbstractXWikiClassCouplingCheck
extends Check {
    private final Set<String> mIgnoredClassNames = Sets.newHashSet();
    private final FastStack<Context> mContextStack = FastStack.newInstance();
    private int mMax;
    private String mPackageName;
    private Context mContext;

    protected AbstractXWikiClassCouplingCheck(int aDefaultMax) {
        this.setMax(aDefaultMax);
        this.mIgnoredClassNames.add("boolean");
        this.mIgnoredClassNames.add("byte");
        this.mIgnoredClassNames.add("char");
        this.mIgnoredClassNames.add("double");
        this.mIgnoredClassNames.add("float");
        this.mIgnoredClassNames.add("int");
        this.mIgnoredClassNames.add("long");
        this.mIgnoredClassNames.add("short");
        this.mIgnoredClassNames.add("void");
        this.mIgnoredClassNames.add("Boolean");
        this.mIgnoredClassNames.add("Byte");
        this.mIgnoredClassNames.add("Character");
        this.mIgnoredClassNames.add("Double");
        this.mIgnoredClassNames.add("Float");
        this.mIgnoredClassNames.add("Integer");
        this.mIgnoredClassNames.add("Long");
        this.mIgnoredClassNames.add("Object");
        this.mIgnoredClassNames.add("Short");
        this.mIgnoredClassNames.add("String");
        this.mIgnoredClassNames.add("StringBuffer");
        this.mIgnoredClassNames.add("Void");
        this.mIgnoredClassNames.add("ArrayIndexOutOfBoundsException");
        this.mIgnoredClassNames.add("Exception");
        this.mIgnoredClassNames.add("RuntimeException");
        this.mIgnoredClassNames.add("IllegalArgumentException");
        this.mIgnoredClassNames.add("IllegalStateException");
        this.mIgnoredClassNames.add("IndexOutOfBoundsException");
        this.mIgnoredClassNames.add("NullPointerException");
        this.mIgnoredClassNames.add("Throwable");
        this.mIgnoredClassNames.add("SecurityException");
        this.mIgnoredClassNames.add("UnsupportedOperationException");
        this.mIgnoredClassNames.add("Class");
        this.mIgnoredClassNames.add("Map");
        this.mIgnoredClassNames.add("List");
        this.mIgnoredClassNames.add("HashMap");
        this.mIgnoredClassNames.add("ArrayList");
        this.mIgnoredClassNames.add("Locale");
    }

    public final int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    public final int getMax() {
        return this.mMax;
    }

    public final void setMax(int aMax) {
        this.mMax = aMax;
    }

    public final void beginTree(DetailAST aAST) {
        this.mPackageName = "";
    }

    protected abstract String getLogMessageId();

    public void visitToken(DetailAST aAST) {
        switch (aAST.getType()) {
            case 16: {
                this.visitPackageDef(aAST);
                break;
            }
            case 14: 
            case 15: 
            case 154: 
            case 157: {
                this.visitClassDef(aAST);
                break;
            }
            case 13: {
                this.mContext.visitType(aAST);
                break;
            }
            case 136: {
                this.mContext.visitLiteralNew(aAST);
                break;
            }
            case 81: {
                this.mContext.visitLiteralThrows(aAST);
                break;
            }
            default: {
                throw new IllegalStateException(aAST.toString());
            }
        }
    }

    public void leaveToken(DetailAST aAST) {
        switch (aAST.getType()) {
            case 14: 
            case 15: 
            case 154: 
            case 157: {
                this.leaveClassDef();
                break;
            }
        }
    }

    private void visitPackageDef(DetailAST aPkg) {
        FullIdent ident = FullIdent.createFullIdent((DetailAST)aPkg.getLastChild().getPreviousSibling());
        this.mPackageName = ident.getText();
    }

    private void visitClassDef(DetailAST aClassDef) {
        this.mContextStack.push((Object)this.mContext);
        String className = aClassDef.findFirstToken(58).getText();
        this.mContext = new Context(className, aClassDef.getLineNo(), aClassDef.getColumnNo());
    }

    private void leaveClassDef() {
        this.mContext.checkCoupling();
        this.mContext = (Context)this.mContextStack.pop();
    }

    private class Context {
        private final Set<String> mReferencedClassNames = Sets.newTreeSet();
        private final String mClassName;
        private final int mLineNo;
        private final int mColumnNo;

        public Context(String aClassName, int aLineNo, int aColumnNo) {
            this.mClassName = aClassName;
            this.mLineNo = aLineNo;
            this.mColumnNo = aColumnNo;
        }

        public void visitLiteralThrows(DetailAST aThrows) {
            for (DetailAST childAST = aThrows.getFirstChild(); childAST != null; childAST = childAST.getNextSibling()) {
                if (childAST.getType() == 74) continue;
                this.addReferencedClassName(childAST);
            }
        }

        public void visitType(DetailAST aAST) {
            String className = CheckUtils.createFullType((DetailAST)aAST).getText();
            AbstractXWikiClassCouplingCheck.this.mContext.addReferencedClassName(className);
        }

        public void visitLiteralNew(DetailAST aAST) {
            AbstractXWikiClassCouplingCheck.this.mContext.addReferencedClassName(aAST.getFirstChild());
        }

        private void addReferencedClassName(DetailAST aAST) {
            String className = FullIdent.createFullIdent((DetailAST)aAST).getText();
            this.addReferencedClassName(className);
        }

        private void addReferencedClassName(String aClassName) {
            if (this.isSignificant(aClassName)) {
                this.mReferencedClassNames.add(aClassName);
            }
        }

        public void checkCoupling() {
            this.mReferencedClassNames.remove(this.mClassName);
            this.mReferencedClassNames.remove(AbstractXWikiClassCouplingCheck.this.mPackageName + "." + this.mClassName);
            if (this.mReferencedClassNames.size() > AbstractXWikiClassCouplingCheck.this.mMax) {
                AbstractXWikiClassCouplingCheck.this.log(this.mLineNo, this.mColumnNo, AbstractXWikiClassCouplingCheck.this.getLogMessageId(), new Object[]{this.mReferencedClassNames.size(), AbstractXWikiClassCouplingCheck.this.getMax(), this.mReferencedClassNames.toString()});
            }
        }

        private boolean isSignificant(String aClassName) {
            return aClassName.length() > 0 && !AbstractXWikiClassCouplingCheck.this.mIgnoredClassNames.contains(aClassName) && !aClassName.startsWith("java.lang.");
        }
    }
}

