/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.util.ContextInitializer;
import ch.qos.logback.core.read.ListAppender;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.xwiki.test.LogLevel;

public class AllLogRule
implements TestRule {
    private final ListAppender<ILoggingEvent> listAppender = new ListAppender();
    private final Set<Integer> assertedMessages = new HashSet<Integer>();
    private LogLevel level;

    public AllLogRule() {
        this(LogLevel.INFO);
    }

    public AllLogRule(LogLevel level) {
        this.level = level;
    }

    public Statement apply(Statement statement, Description description) {
        return new LogStatement(statement);
    }

    public ILoggingEvent getLogEvent(int position) {
        List list = this.listAppender.list;
        if (list.size() <= position) {
            throw new RuntimeException(String.format("There are only %s messages in the captured logs", list.size()));
        }
        this.assertedMessages.add(position);
        return (ILoggingEvent)list.get(position);
    }

    public String getMessage(int position) {
        return this.getLogEvent(position).getFormattedMessage();
    }

    public Marker getMarker(int position) {
        return this.getLogEvent(position).getMarker();
    }

    public int size() {
        return this.listAppender.list.size();
    }

    public void ignoreAllMessages() {
        for (int i = 0; i < this.size(); ++i) {
            this.getLogEvent(i);
        }
    }

    public void ignoreMessage(int position) {
        this.getLogEvent(position);
    }

    private void initializeLoggers() {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        context.reset();
        Logger logger = (Logger)LoggerFactory.getLogger((String)"ROOT");
        logger.addAppender(this.listAppender);
        logger.setLevel(this.level.getLevel());
    }

    private void uninitializeLogger(boolean verify) throws Exception {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        context.reset();
        ContextInitializer initializer = new ContextInitializer(context);
        initializer.autoConfig();
        if (this.listAppender.list.size() != this.assertedMessages.size()) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < this.listAppender.list.size(); ++i) {
                if (this.assertedMessages.contains(i)) continue;
                builder.append(this.getMessage(i)).append('\n');
            }
            throw new AssertionError((Object)String.format("Following messages must be asserted: [%s]", builder.toString()));
        }
    }

    public class LogStatement
    extends Statement {
        private final Statement statement;

        public LogStatement(Statement statement) {
            this.statement = statement;
        }

        public void evaluate() throws Throwable {
            this.before();
            boolean validate = true;
            try {
                this.statement.evaluate();
            }
            catch (Throwable t) {
                validate = false;
                throw t;
            }
            finally {
                this.after(validate);
            }
        }

        private void before() throws Throwable {
            AllLogRule.this.initializeLoggers();
            AllLogRule.this.listAppender.start();
        }

        private void after(boolean verify) throws Throwable {
            AllLogRule.this.listAppender.stop();
            AllLogRule.this.uninitializeLogger(verify);
        }
    }
}

