/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.junit5;

import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.test.junit5.RuntimeUtils;

public class FailingTestDebuggingTestExecutionListener
implements TestExecutionListener {
    static final String START_MESSAGE = "---- Start of environment debugging information";
    static final String STOP_MESSAGE = "---- End of environment debugging information";
    private static final Logger LOGGER = LoggerFactory.getLogger(FailingTestDebuggingTestExecutionListener.class);

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        if (testExecutionResult.getThrowable().isPresent() && this.isInCI()) {
            LOGGER.info(START_MESSAGE);
            LOGGER.info(RuntimeUtils.run("top -b -n 1"));
            LOGGER.info(RuntimeUtils.run("lsof -i -P -n"));
            LOGGER.info(RuntimeUtils.run("docker ps -a"));
            LOGGER.info(RuntimeUtils.run("docker events --since '15m' --until '0m'"));
            LOGGER.info(STOP_MESSAGE);
        }
    }

    private boolean isInCI() {
        return System.getenv("NODE_NAME") != null || Boolean.parseBoolean(System.getProperty("inCI"));
    }
}

