/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.test.jmock.annotation;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

/**
 * Used to be able to define several {@link MockingRequirement} annotations.
 *
 * @version $Id: 78c7c29b0054ca8dc8b3dc3745e082755a1cf941 $
 * @since 4.2M3
 * @deprecated use {@link org.xwiki.test.junit5.mockito.InjectMockComponents} instead
 */
@Deprecated(since = "4.3.1")
@Retention(RUNTIME)
@Target(TYPE)
public @interface MockingRequirements
{
    /**
     * @return the list of annotations within the compound
     */
    MockingRequirement[] value();
}
