/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.tool.extension;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.xwiki.tool.extension.util.AbstractExtensionMojo;

@Mojo(name="war", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresDependencyResolution=ResolutionScope.RUNTIME, requiresProject=true, threadSafe=true)
public class WarMojo
extends AbstractExtensionMojo {
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}", required=true)
    private File webappDirectory;

    @Override
    public void executeInternal() throws MojoExecutionException {
        this.registerWAR();
        this.registerDependencies();
    }

    private void registerWAR() throws MojoExecutionException {
        File directory = new File(this.webappDirectory, "META-INF");
        directory.mkdirs();
        try {
            this.extensionHelper.serializeExtension(new File(directory, "extension.xed"), this.project.getModel());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to write WAR descriptor", e);
        }
    }

    private void registerDependencies() throws MojoExecutionException {
        File libDirectory = new File(this.webappDirectory, "WEB-INF/lib/");
        libDirectory.mkdirs();
        this.extensionHelper.serializeExtensions(this.project.getArtifacts(), libDirectory, "jar");
    }
}

