/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.tool.extension;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.xwiki.tool.extension.util.AbstractExtensionMojo;

@Mojo(name="war", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresDependencyResolution=ResolutionScope.RUNTIME, requiresProject=true, threadSafe=true)
public class WarMojo
extends AbstractExtensionMojo {
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}", required=true)
    private File webappDirectory;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject project;

    public void execute() throws MojoExecutionException {
        this.initializeComponents();
        this.registerWAR();
        this.registerDependencies();
        this.disposeComponents();
    }

    private void registerWAR() throws MojoExecutionException {
        File directory = new File(this.webappDirectory, "META-INF");
        directory.mkdirs();
        try {
            this.saveExtension(new File(directory, "extension.xed"), this.project.getModel());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to write WAR descriptor", e);
        }
    }

    private void registerDependencies() throws MojoExecutionException {
        File libDirectory = new File(this.webappDirectory, "WEB-INF/lib/");
        libDirectory.mkdirs();
        this.saveExtensions(this.project.getArtifacts(), libDirectory, "jar");
    }
}

