/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.tool.extension.util;

import org.apache.commons.lang3.StringUtils;

/**
 * 
 * @version $Id: 20d17d5574751588846e3b10a2ca41e28c0dd708 $
 * @since 9.4RC1
 */
public class ExtensionArtifact
{
    private String groupId;

    private String artifactId;

    private String version;

    private String type;

    public String getGroupId()
    {
        return groupId;
    }

    public void setGrouId(String grouId)
    {
        this.groupId = grouId;
    }

    public String getArtifactId()
    {
        return artifactId;
    }

    public void setArtifactId(String artifactId)
    {
        this.artifactId = artifactId;
    }

    public String getVersion()
    {
        return version;
    }

    public void setVersion(String version)
    {
        this.version = version;
    }

    public String getType()
    {
        return type;
    }

    public void setType(String type)
    {
        this.type = type;
    }

    public void set(String value)
    {
        String[] values = StringUtils.split(value, ':');

        setGrouId(values[0]);
        setArtifactId(values[1]);
        if (values.length >= 3) {
            setVersion(values[2]);
        }
        if (values.length >= 4) {
            setType(values[3]);
        }
    }
}